/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers.jmx;

import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.sbc.bo.shiro.ShiroResources;
import org.restcomm.sbc.managers.jmx.JMXProvider;

public class JMXProviderFactory {
    private static transient Logger LOG = Logger.getLogger(JMXProviderFactory.class);
    private static JMXProvider instance;

    private JMXProviderFactory() {
    }

    public static JMXProvider getJMXProvider() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String providerClass;
        if (instance != null) {
            return instance;
        }
        Configuration configuration = (Configuration)ShiroResources.getInstance().get(Configuration.class);
        if (configuration == null) {
            providerClass = "org.restcomm.sbc.managers.jmx.tomcat.Provider";
        } else {
            providerClass = configuration.getString("jmx-management.provider");
            if (providerClass == null) {
                providerClass = "org.restcomm.sbc.managers.jmx.tomcat.Provider";
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Factoring JMXProvider " + providerClass));
        }
        Class<?> factory = Class.forName(providerClass);
        instance = (JMXProvider)factory.newInstance();
        return instance;
    }
}

