/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.restcomm.sbc.managers.CacheManager;
import org.restcomm.sbc.threat.Threat;

public class ThreatManager {
    private Cache<String, Threat> threats = CacheManager.getCacheManager().getCache("threats");
    private static ThreatManager threatManager;

    private ThreatManager() {
        this.threats.start();
    }

    public static ThreatManager getThreatManager() {
        if (threatManager == null) {
            threatManager = new ThreatManager();
        }
        return threatManager;
    }

    public Threat create(Threat.Type type, String user, String host, int port, String userAgent, String transport) {
        Threat threat = new Threat();
        threat.setHost(host);
        threat.setPort(port);
        threat.setUserAgent(userAgent);
        threat.setTransport(transport);
        threat.setUser(user);
        threat.setType(type);
        this.threats.put((Object)host, (Object)threat, 90L, TimeUnit.SECONDS);
        return threat;
    }

    public Threat getThreat(String host) {
        return (Threat)this.threats.get((Object)host);
    }

    public Collection<Threat> getThreats() {
        ArrayList<Threat> al = new ArrayList<Threat>((Collection<Threat>)this.threats.values());
        return al;
    }

    public boolean match(String host) {
        Threat threat = this.getThreat(host);
        return threat != null && threat.getHost().equals(host);
    }
}

