/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.sbc.router.RoutingPolicy;
import org.restcomm.sbc.router.impl.FailoverRoutingPolicy;
import org.restcomm.sbc.router.impl.HARoutingPolicy;
import org.restcomm.sbc.router.impl.StaticRoutingPolicy;
import org.restcomm.sbc.router.impl.UnavailableRoutingPolicyException;

public class RoutingPolicyFactory {
    public static String STATIC = "static";
    public static String FAILOVER = "fail-over";
    public static String HA = "load-balance";
    private static transient Logger LOG = Logger.getLogger(RoutingPolicyFactory.class);
    private HashMap<String, RoutingPolicy> policies = new HashMap();
    private static RoutingPolicyFactory routingPolicyFactory;

    private RoutingPolicyFactory() {
        this.registerRouter(STATIC, (RoutingPolicy)new StaticRoutingPolicy());
        this.registerRouter(FAILOVER, (RoutingPolicy)new FailoverRoutingPolicy());
        this.registerRouter(HA, (RoutingPolicy)new HARoutingPolicy());
    }

    public static RoutingPolicyFactory getRoutingPolicyFactory() {
        if (routingPolicyFactory == null) {
            routingPolicyFactory = new RoutingPolicyFactory();
        }
        return routingPolicyFactory;
    }

    private void registerRouter(String policyName, RoutingPolicy policy) {
        this.policies.put(policyName, policy);
    }

    public RoutingPolicy getPolicy(String policy) throws UnavailableRoutingPolicyException {
        if (policy == null) {
            throw new UnavailableRoutingPolicyException(policy + " routing policy unavailable");
        }
        RoutingPolicy p = (RoutingPolicy)this.policies.get(policy.toLowerCase());
        if (p == null) {
            throw new UnavailableRoutingPolicyException(policy + " protocol policy unavailable");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(">> Factoring RoutingPolicy [" + p.getName() + "]"));
        }
        return p;
    }

    public RoutingPolicy getPolicy(Configuration config) throws UnavailableRoutingPolicyException {
        String name = config.getString("runtime-settings.routing-policy.policy[@name]");
        List targets = config.getList("runtime-settings.routing-policy.policy.militarized-zone-target.target");
        if (name == null) {
            throw new UnavailableRoutingPolicyException("routing policy unavailable");
        }
        RoutingPolicy p = (RoutingPolicy)this.policies.get(name);
        if (p == null) {
            throw new UnavailableRoutingPolicyException(name + " protocol policy unavailable");
        }
        p.setTargets(targets);
        return p;
    }
}

