/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl.registrar;

import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultDPIProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.managers.RouteManager;

public class RegistrarDPIProcessor
extends DefaultDPIProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(RegistrarDPIProcessor.class);
    private String name = "PRE-REGISTRAR DPI Processor";

    public RegistrarDPIProcessor(ProcessorChain chain) {
        super(chain);
        this.chain = chain;
    }

    public RegistrarDPIProcessor(String name, ProcessorChain chain) {
        this(chain);
        this.setName(name);
    }

    private void processRequest(SIPMutableMessage message) {
        SipServletRequest dmzRequest;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processRequest()");
        }
        if (!RouteManager.isFromDMZ((SipServletMessage)(dmzRequest = (SipServletRequest)message.getContent()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Rejecting REGISTER from unauthorized NetworkPoint!");
            }
            SipServletResponse dmzResponse = dmzRequest.createResponse(403);
            message.setContent((Object)dmzResponse);
            message.unlink();
            return;
        }
    }

    private void processResponse(SIPMutableMessage message) {
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        m.setSourceLocalAddress(sm.getLocalAddr());
        m.setSourceRemoteAddress(sm.getRemoteAddr());
        if (sm instanceof SipServletRequest) {
            this.processRequest(m);
        }
        if (sm instanceof SipServletResponse) {
            this.processResponse(m);
        }
    }

    public String getVersion() {
        return "1.0.0";
    }
}

