/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl;

import java.net.NoRouteToHostException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.sbc.adapter.ProtocolAdapter;
import org.restcomm.sbc.adapter.UnavailableProtocolAdapterException;
import org.restcomm.sbc.managers.ProtocolAdapterFactory;
import org.restcomm.sbc.managers.RouteManager;

public class ProtocolAdaptProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(ProtocolAdaptProcessor.class);
    private String name = "Protocol Adapt Processor";
    protected ProtocolAdapterFactory protocolAdapterFactory = ProtocolAdapterFactory.getProtocolAdapterFactory();
    protected RouteManager routeManager;

    public ProtocolAdaptProcessor(ProcessorChain processorChain) {
        super(processorChain);
    }

    public ProtocolAdaptProcessor(String name, ProcessorChain processorChain) {
        this(processorChain);
        this.setName(name);
    }

    private void processResponse(Message message) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processResponse()");
            LOG.trace((Object)message.toString());
            LOG.trace(message.getMetadata());
        }
        ProtocolAdapter adapter = null;
        try {
            adapter = this.protocolAdapterFactory.getAdapter(message.getTargetTransport());
            message = adapter.adapt(message);
        }
        catch (UnavailableProtocolAdapterException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        catch (NoRouteToHostException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
    }

    private void processRequest(Message message) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processRequest()");
            LOG.trace((Object)message.toString());
        }
        ProtocolAdapter adapter = null;
        try {
            adapter = this.protocolAdapterFactory.getAdapter(message.getTargetTransport());
            message = adapter.adapt(message);
        }
        catch (UnavailableProtocolAdapterException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        catch (NoRouteToHostException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        SipServletMessage sm = (SipServletMessage)message.getContent();
        if (sm instanceof SipServletRequest) {
            this.processRequest(message);
        }
        if (sm instanceof SipServletResponse) {
            this.processResponse(message);
        }
    }

    public String getVersion() {
        return "1.0.0";
    }
}

