/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl;

import java.io.IOException;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultDPIProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;

public class DispatchDPIProcessor
extends DefaultDPIProcessor
implements ProcessorCallBack {
    private String name = "Dispatch DPI Processor";
    private static transient Logger LOG = Logger.getLogger(DispatchDPIProcessor.class);

    public DispatchDPIProcessor(ProcessorChain processorChain) {
        super(processorChain);
    }

    public DispatchDPIProcessor(String name, ProcessorChain processorChain) {
        super(name, processorChain);
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.hashCode();
    }

    public SipServletMessage doProcess(SIPMutableMessage message) throws ProcessorParsingException {
        SipServletMessage m = message.getContent();
        SipServletResponse r = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("-------" + m.getLocalAddr() + "->" + m.getTo().getURI().toString()));
            LOG.trace((Object)("-------Dispatching message: \n" + m));
        }
        try {
            if (m instanceof SipServletResponse && (r = (SipServletResponse)m).getStatus() >= 100 && r.getStatus() < 200) {
                try {
                    r.sendReliably();
                    return r;
                }
                catch (Rel100Exception e) {
                    LOG.warn((Object)"rel100 not supported!");
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("!" + e.getMessage()));
                }
            }
            m.send();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("!Cannot dispatch " + m.getMethod() + "/" + (r != null ? r.getStatus() + ":" + r.getReasonPhrase() : "")));
        }
        return m;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        this.doProcess((SIPMutableMessage)message);
    }

    public String getVersion() {
        return "1.0.0";
    }
}

