/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.sip.Address;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.Location;
import org.restcomm.sbc.bo.LocationNotFoundException;
import org.restcomm.sbc.managers.LocationManager;
import org.restcomm.sbc.managers.MessageUtil;
import org.restcomm.sbc.managers.RouteManager;
import org.restcomm.sbc.router.RoutingPolicy;

public class B2BUABuilderProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(B2BUABuilderProcessor.class);
    private LocationManager locationManager;
    private SipFactory sipFactory;
    private SipApplicationSession aSession;
    private RoutingPolicy routingPolicy = ConfigurationCache.getRoutingPolicy();

    public B2BUABuilderProcessor(ProcessorChain chain) {
        super(chain);
        this.chain = chain;
        this.locationManager = LocationManager.getLocationManager();
        this.sipFactory = ConfigurationCache.getSipFactory();
    }

    public B2BUABuilderProcessor(String name, ProcessorChain chain) {
        this(chain);
        this.setName(name);
    }

    private void processRequest(SIPMutableMessage message) {
        SipURI route;
        SipURI toURI;
        SipServletRequest request = (SipServletRequest)message.getContent();
        B2buaHelper helper = request.getB2buaHelper();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(">> processRequest() Initial/Linked=" + request.isInitial() + "/" + helper.getLinkedSession(request.getSession())));
        }
        SipServletRequest newRequest = null;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        SipURI fromURI = (SipURI)request.getFrom().getURI();
        SipURI newSipToUri = toURI = (SipURI)request.getTo().getURI();
        Address contactURI = null;
        RouteManager routeManager = RouteManager.getRouteManager();
        Connector connector = null;
        InetSocketAddress outBoundInterface = null;
        if (message.getDirection() == 0) {
            SipURI candidate;
            message.setTarget(1);
            try {
                connector = routeManager.getRouteToMZ(request.getLocalAddr(), request.getLocalPort(), request.getInitialTransport());
                outBoundInterface = connector.getOutboundInterface();
                contactURI = routeManager.getFromAddress(fromURI, outBoundInterface);
            }
            catch (Exception e) {
                LOG.error((Object)"ERROR", (Throwable)e);
            }
            if (LOG.isTraceEnabled()) {
                headers.put(MessageUtil.B2BUA_FINGERPRINT_HEADER, Arrays.asList("Made in RequestBuilder to MZ"));
                LOG.trace((Object)("Connector to build OB " + connector.toPrint()));
            }
            message.setTargetLocalAddress(connector.getHost());
            message.setTargetRemoteAddress(this.routingPolicy.getCandidate().getHost());
            message.setTargetTransport(connector.getTransport().toString());
            route = candidate = this.routingPolicy.getCandidate();
        } else {
            message.setTarget(0);
            Location location = null;
            try {
                location = this.locationManager.getLocation(toURI.getUser() + "@" + ConfigurationCache.getDomain());
                outBoundInterface = routeManager.getOutboundProxy(location.getSourceConnectorSid().toString());
                connector = routeManager.getDMZConnector(location.getSourceConnectorSid().toString());
                contactURI = routeManager.getFromAddress(fromURI, outBoundInterface);
                message.setTargetLocalAddress(ConfigurationCache.getIpOfDomain());
                message.setTargetRemoteAddress(location.getHost());
                message.setTargetTransport(location.getTransport().toUpperCase());
            }
            catch (LocationNotFoundException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.error((Object)e);
                }
                SipServletResponse response = request.createResponse(403);
                message.setContent((Object)response);
                message.unlink();
                return;
            }
            catch (NoRouteToHostException e) {
                LOG.error((Object)"ERROR", (Throwable)e);
                SipServletResponse response = request.createResponse(403);
                message.setContent((Object)response);
                message.unlink();
                return;
            }
            newSipToUri = this.sipFactory.createSipURI(toURI.getUser(), location.getHost());
            newSipToUri.setPort(location.getPort());
            newSipToUri.setTransportParam(location.getTransport());
            connector = routeManager.getDMZConnector(location.getSourceConnectorSid().toString());
            fromURI.setHost(connector.getHost());
            fromURI.setTransportParam(connector.getTransport().name());
            fromURI.setPort(connector.getPort());
            route = null;
        }
        try {
            if (request.isInitial()) {
                headers.put("Contact", Arrays.asList(contactURI.toString()));
                if (LOG.isTraceEnabled() && this.aSession != null && this.aSession.isValid()) {
                    LOG.trace((Object)("LNK " + this.aSession.getAttribute(request.getSession().getCallId())));
                }
                SipServletRequest usedRequest = null;
                if (this.aSession != null && this.aSession.isValid()) {
                    usedRequest = (SipServletRequest)this.aSession.getAttribute(request.getSession().getCallId());
                }
                if (usedRequest != null && usedRequest.getSession().isValid()) {
                    LOG.trace((Object)("REUSING SESSION REQ " + usedRequest.getCallId() + ":" + usedRequest.getHeader("CSeq")));
                    LOG.trace((Object)("ContactURI on creation " + contactURI.toString()));
                    usedRequest.setMaxForwards(70);
                    newRequest = helper.createRequest(usedRequest.getSession(), request, headers);
                    try {
                        newRequest.setAddressHeader("Contact", contactURI);
                    }
                    catch (Exception e) {
                        LOG.trace((Object)e.getMessage());
                    }
                    String auth = request.getHeader("Authorization");
                    newRequest.removeHeader("Authorization");
                    if (auth != null) {
                        newRequest.addHeader("Authorization", auth);
                    }
                } else {
                    LOG.trace((Object)("ContactURI on creation " + contactURI.toString()));
                    newRequest = helper.createRequest(request, true, headers);
                    try {
                        newRequest.setAddressHeader("Contact", contactURI);
                    }
                    catch (Exception e) {
                        LOG.trace((Object)e.getMessage());
                    }
                    newRequest.getApplicationSession().setExpires(0);
                    this.aSession = this.sipFactory.createApplicationSession();
                    this.aSession.setAttribute(request.getSession().getCallId(), (Object)newRequest);
                    LOG.trace((Object)("NEW SESSION REQ/OLD " + newRequest.getSession() + "/" + request.getSession()));
                }
                if (route != null) {
                    newRequest.getSession().setOutboundInterface(outBoundInterface);
                    newRequest.pushRoute(route);
                    route = null;
                } else {
                    newRequest.setRequestURI((URI)newSipToUri);
                    newRequest.getTo().setURI((URI)newSipToUri);
                    newRequest.getFrom().setURI((URI)fromURI);
                }
            } else {
                SipSession session = request.getSession();
                SipSession linkedSession = helper.getLinkedSession(session);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("NOT Initial Request " + request.getMethod()));
                    LOG.trace((Object)("SES " + session.toString()));
                    LOG.trace((Object)("LNK " + linkedSession));
                }
                if (linkedSession == null) {
                    LOG.warn((Object)("No linked session for request " + request.getMethod()));
                    linkedSession = session;
                }
                if (request.getMethod().equals("BYE")) {
                    newRequest = linkedSession.createRequest("BYE");
                } else if (request.getMethod().equals("CANCEL")) {
                    SipServletRequest originalRequest = (SipServletRequest)linkedSession.getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
                    newRequest = helper.getLinkedSipServletRequest(originalRequest).createCancel();
                } else if (request.getMethod().equals("INVITE")) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Reinviting?");
                    }
                    newRequest = linkedSession.createRequest("INVITE");
                } else if (request.getMethod().equals("ACK")) {
                    newRequest = linkedSession.createRequest("ACK");
                } else if (request.getMethod().equals("INFO")) {
                    newRequest = linkedSession.createRequest("INFO");
                    newRequest.setContent(request.getContent(), request.getContentType());
                } else {
                    LOG.error((Object)(request.getMethod() + " not implemented!"));
                }
            }
            newRequest.getSession().setAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR, (Object)request);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Initial Request " + request.getMethod() + " on session " + newRequest.getSession().getId()));
                LOG.trace((Object)("Routing thru outboundInterface " + outBoundInterface.toString()));
                LOG.trace((Object)("Routing To " + route));
                LOG.trace((Object)("Contact back " + contactURI.toString()));
                LOG.trace((Object)("Sending Message: \n " + newRequest.toString()));
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (TooManyHopsException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        message.setContent(newRequest);
    }

    private void processResponse(SIPMutableMessage message) {
        SipServletResponse mzResponse;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> processResponse()");
        }
        if (message.getDirection() == 0) {
            message.setTarget(1);
        } else {
            message.setTarget(0);
        }
        SipServletResponse dmzResponse = (SipServletResponse)message.getContent();
        B2buaHelper helper = dmzResponse.getRequest().getB2buaHelper();
        int statusResponse = dmzResponse.getStatus();
        String reasonResponse = dmzResponse.getReasonPhrase();
        SipServletRequest linked = helper.getLinkedSipServletRequest(dmzResponse.getRequest());
        SipSession originalSession = helper.getLinkedSession(dmzResponse.getSession());
        if (linked != null) {
            message.setTargetLocalAddress(linked.getLocalAddr());
            message.setTargetRemoteAddress(linked.getRemoteAddr());
            message.setTargetTransport(linked.getTransport().toUpperCase());
            mzResponse = linked.createResponse(statusResponse, reasonResponse);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Reusing linked session");
            }
        } else {
            message.setTargetLocalAddress(dmzResponse.getLocalAddr());
            message.setTargetRemoteAddress(dmzResponse.getRemoteAddr());
            message.setTargetTransport(dmzResponse.getTransport().toUpperCase());
            if (originalSession == null) {
                message.abort();
                message.setContent((Object)dmzResponse);
                return;
            }
            mzResponse = helper.createResponseToOriginalRequest(originalSession, statusResponse, reasonResponse);
            LOG.warn((Object)">>>>>>>>>>>>Must Abort Message flow?, No linked Session available.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("mz Response created for session " + originalSession.getId()));
        }
        try {
            if (dmzResponse.getContent() != null) {
                mzResponse.setContent(dmzResponse.getContent(), dmzResponse.getContentType());
            }
            mzResponse.setHeaderForm(dmzResponse.getHeaderForm());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        try {
            if (dmzResponse.getStatus() == 407) {
                mzResponse.setHeader("Proxy-Authenticate", dmzResponse.getHeader("Proxy-Authenticate"));
            } else if (dmzResponse.getStatus() == 401) {
                mzResponse.setHeader("WWW-Authenticate", dmzResponse.getHeader("WWW-Authenticate"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        mzResponse.getSession().setAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR, (Object)dmzResponse.getRequest());
        message.setContent((Object)mzResponse);
    }

    public String getName() {
        return "B2BUA leg builder Processor";
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = (SipServletMessage)message.getContent();
        if (sm instanceof SipServletRequest) {
            this.processRequest(m);
        }
        if (sm instanceof SipServletResponse) {
            this.processResponse(m);
        }
    }

    public String getVersion() {
        return "1.0.0";
    }
}

