/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import org.joda.time.DateTime;
import org.restcomm.sbc.bo.Sid;

public class Location {
    private String user;
    private String domain;
    private String host;
    private int port;
    private String transport;
    private String userAgent;
    private String callID;
    private int cSeq;
    private Sid sourceConnectorSid;
    private DateTime expires;

    public Location(String user, String domain, String host, int port, String transport, Sid sourceConnectorSid) {
        this.user = user;
        this.domain = domain;
        this.host = host;
        this.sourceConnectorSid = sourceConnectorSid;
        this.port = port <= 0 ? 5060 : port;
        this.transport = transport == null ? "UDP" : transport.toUpperCase();
    }

    public String getUser() {
        return this.user;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isExpired() {
        return this.getExpires().isAfterNow();
    }

    public long getMiliSecondsToExpiration() {
        return this.getExpires().minus(System.currentTimeMillis()).getMillis();
    }

    public String toString() {
        return "<Location> user:" + this.user + "@" + this.domain + " expires on MZ " + this.getMiliSecondsToExpiration() + "\nms host:" + this.getHost() + ":" + this.getPort() + " transport:" + this.getTransport() + " User-Agent:" + this.userAgent + " Call-ID " + this.callID + " CSeq " + this.cSeq;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public DateTime getExpires() {
        return this.expires;
    }

    public void setExpires(DateTime expireTimestamp) {
        this.expires = expireTimestamp;
    }

    public void setExpirationTimeInSeconds(int expires) {
        this.setExpires(DateTime.now().plus((long)(expires * 1000)));
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public boolean equals(Object location) {
        Location otherLocation = (Location)location;
        if (!(location instanceof Location)) {
            return false;
        }
        return otherLocation.domain.equals(this.domain) && otherLocation.user.equals(this.user);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.user == null ? 0 : this.user.hashCode());
        result = prime * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = prime * result + (this.callID == null ? 0 : this.callID.hashCode());
        result = prime * result + this.cSeq;
        return result;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getCallID() {
        return this.callID;
    }

    public void setCallID(String callID) {
        this.callID = callID;
    }

    public int getcSeq() {
        return this.cSeq;
    }

    public void setcSeq(int cSeq) {
        this.cSeq = cSeq;
    }

    public Sid getSourceConnectorSid() {
        return this.sourceConnectorSid;
    }

    public void setSourceConnectorSid(Sid sourceConnectorSid) {
        this.sourceConnectorSid = sourceConnectorSid;
    }
}

