/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.sip.SipFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.sbc.managers.RoutingPolicyFactory;
import org.restcomm.sbc.router.RoutingPolicy;
import org.restcomm.sbc.router.impl.UnavailableRoutingPolicyException;

public class ConfigurationCache {
    private static String domain;
    private static RoutingPolicy routingPolicy;
    private static SipFactory sipFactory;
    private static boolean regThrottleEnabled;
    private static int regThrottleMZTTL;
    private static int regThrottleUATTL;
    private static int mediaStartPort;
    private static int mediaEndPort;
    private static boolean mediaDecryptionEnabled;
    private static String ipOfDomain;
    private static String apiVersion;
    private static int rtpLog;
    private static List<String> localNetworks;
    private static String home;
    private static transient Logger LOG;

    private ConfigurationCache(SipFactory factory, Configuration configuration) {
        sipFactory = factory;
        home = configuration.getString("runtime-settings.home-directory");
        apiVersion = configuration.getString("runtime-settings.api-version");
        domain = configuration.getString("runtime-settings.domain");
        try {
            routingPolicy = RoutingPolicyFactory.getRoutingPolicyFactory().getPolicy(configuration);
        }
        catch (UnavailableRoutingPolicyException e1) {
            LOG.fatal((Object)"Cannot get Routing Policy ");
            System.exit(101);
        }
        regThrottleEnabled = configuration.getBoolean("registrar-throttle.enable");
        regThrottleMZTTL = configuration.getInt("registrar-throttle.force-mz-expiration");
        regThrottleUATTL = configuration.getInt("registrar-throttle.force-ua-expiration");
        mediaStartPort = configuration.getInt("media-proxy.start-port");
        mediaEndPort = configuration.getInt("media-proxy.end-port");
        rtpLog = configuration.getInt("media-proxy.rtp-log");
        mediaDecryptionEnabled = configuration.getBoolean("media-proxy.security-policy.encryption-handle");
        ipOfDomain = "";
        localNetworks = configuration.getList("runtime-settings.nat-helper.local-networks.local-address");
        try {
            ipOfDomain = InetAddress.getByName(domain).getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.fatal((Object)("Cannot resolve IP Address of " + domain));
            System.exit(100);
        }
    }

    public static void build(SipFactory factory, Configuration configuration) {
        new ConfigurationCache(factory, configuration);
    }

    public static SipFactory getSipFactory() {
        return sipFactory;
    }

    public static boolean isRegThrottleEnabled() {
        return regThrottleEnabled;
    }

    public static int getRegThrottleMZTTL() {
        return regThrottleMZTTL;
    }

    public static int getRegThrottleUATTL() {
        return regThrottleUATTL;
    }

    public static String getDomain() {
        return domain;
    }

    public static int getMediaStartPort() {
        return mediaStartPort;
    }

    public static int getMediaEndPort() {
        return mediaEndPort;
    }

    public static String getIpOfDomain() {
        return ipOfDomain;
    }

    public static String getApiVersion() {
        return apiVersion;
    }

    public static List<String> getLocalNetworks() {
        return localNetworks;
    }

    public static boolean isMediaDecryptionEnabled() {
        return mediaDecryptionEnabled;
    }

    public static int getRtpCountLog() {
        return rtpLog;
    }

    public static String getHome() {
        return home;
    }

    public static RoutingPolicy getRoutingPolicy() {
        return routingPolicy;
    }

    static {
        LOG = Logger.getLogger(ConfigurationCache.class);
    }
}

