/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.exceptionmappers;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.restcomm.connect.http.exceptions.InsufficientPermission;
import org.restcomm.connect.http.exceptions.NotAuthenticated;
import org.restcomm.connect.http.exceptions.OperatedAccountMissing;
import org.restcomm.connect.http.exceptions.ResourceAccountMissmatch;
import org.restcomm.connect.http.exceptions.RestcommRuntimeException;

@Provider
public class RestcommRuntimeExceptionMapper
implements ExceptionMapper<RestcommRuntimeException> {
    public Response toResponse(RestcommRuntimeException e) {
        if (e instanceof NotAuthenticated) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"Restcomm realm\"").build();
        }
        if (e instanceof InsufficientPermission) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (e instanceof OperatedAccountMissing) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (e instanceof ResourceAccountMissmatch) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

