/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import java.io.File;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.http.RecordingsEndpoint;

@Path(value="/Accounts/{accountSid}/Recordings")
@ThreadSafe
public final class RecordingsXmlEndpoint
extends RecordingsEndpoint {
    @Path(value="/{sid}.json")
    @GET
    public Response getRecordingAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getRecording(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}.wav")
    @GET
    public Response getRecordingAsWav(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.baseRecordingsPath).append(sid).append(".wav");
        File file = new File(buffer.toString());
        if (!file.exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)file, (String)"audio/wav").build();
    }

    @Path(value="/{sid}")
    @GET
    public Response getRecordingAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getRecording(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getRecordings(@PathParam(value="accountSid") String accountSid) {
        return this.getRecordings(accountSid, MediaType.APPLICATION_XML_TYPE);
    }
}

