/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.StringUtils;

@NotThreadSafe
public abstract class AbstractEndpoint {
    private String defaultApiVersion;
    protected Configuration configuration;
    protected String baseRecordingsPath;

    protected void init(Configuration configuration) {
        String path = configuration.getString("recordings-path");
        this.baseRecordingsPath = StringUtils.addSuffixIfNotPresent((String)path, (String)"/");
        this.defaultApiVersion = configuration.getString("api-version");
    }

    protected String getApiVersion(MultivaluedMap<String, String> data) {
        String apiVersion = this.defaultApiVersion;
        if (data != null && data.containsKey((Object)"ApiVersion")) {
            apiVersion = (String)data.getFirst((Object)"ApiVersion");
        }
        return apiVersion;
    }

    protected Phonenumber.PhoneNumber getPhoneNumber(MultivaluedMap<String, String> data) {
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        Phonenumber.PhoneNumber phoneNumber = null;
        try {
            phoneNumber = phoneNumberUtil.parse((String)data.getFirst((Object)"PhoneNumber"), "US");
        }
        catch (NumberParseException ignored) {
            // empty catch block
        }
        return phoneNumber;
    }

    protected String getMethod(String name, MultivaluedMap<String, String> data) {
        String method = "POST";
        if (data.containsKey((Object)name)) {
            method = (String)data.getFirst((Object)name);
        }
        return method;
    }

    protected Sid getSid(String name, MultivaluedMap<String, String> data) {
        Sid sid = null;
        if (data.containsKey((Object)name)) {
            sid = new Sid((String)data.getFirst((Object)name));
        }
        return sid;
    }

    protected URI getUrl(String name, MultivaluedMap<String, String> data) {
        URI uri = null;
        if (data.containsKey((Object)name)) {
            uri = URI.create((String)data.getFirst((Object)name));
        }
        return uri;
    }

    protected boolean getHasVoiceCallerIdLookup(MultivaluedMap<String, String> data) {
        String value;
        boolean hasVoiceCallerIdLookup = false;
        if (data.containsKey((Object)"VoiceCallerIdLookup") && "true".equalsIgnoreCase(value = (String)data.getFirst((Object)"VoiceCallerIdLookup"))) {
            return true;
        }
        return hasVoiceCallerIdLookup;
    }

    protected boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        return value.equals("");
    }

    String buildErrorResponseBody(String message, MediaType type) {
        if (!type.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            return "{\"message\":" + message + "}";
        }
        return "<RestcommResponse><Message>" + message + "</Message></RestcommResponse>";
    }

    String buildErrorResponseBody(String message, String error, MediaType type) {
        if (!type.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            return "{\"message\":" + message + ",\n\"error\":" + error + "}";
        }
        return "<RestcommResponse><Message>" + message + "</Message><Error>" + error + "</Error></RestcommResponse>";
    }
}

