// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

/**
 * An {@link GenericActionPayloadMetaDataEvent} provides Meta-Data describing
 * the {@link GenericActionPayloadMetaDataEvent} in more detail and a payload as
 * well as an action.
 * 
 * @param <A> The type of the action stored in the event.
 * @param <P> The type of the payload to be carried.
 * @param <EM> The type of the EventMetaData
 * @param <SRC> The type of the source in question.
 */
public interface GenericActionPayloadMetaDataEvent<A, P, EM extends EventMetaData, SRC> extends GenericActionMetaDataEvent<A, EM, SRC>, GenericPayloadMetaDataEvent<P, EM, SRC>, GenericActionPayloadEvent<A, P, SRC> {

	/**
	 * Builder extension for the {@link GenericActionPayloadMetaDataEvent} type.
	 *
	 * @param <A> The type of the action stored in the event.
	 * @param <EM> The type of the EventMetaData
	 * @param <SRC> The type of the source in question.
	 * @param <B> The type of the builder to be returned by the builder methods.
	 */
	public interface GenericActionPayloadMetaDataEventBuilder<A, P, EM extends EventMetaData, SRC, B extends GenericActionPayloadMetaDataEventBuilder<A, P, EM, SRC, B>> extends GenericActionPayloadMetaDataEvent<A, P, EM, SRC>, GenericActionMetaDataEventBuilder<A, EM, SRC, B>, PayloadProperty<P>, PayloadBuilder<P, B> {

	}

}
