// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.observer;

import org.refcodes.observer.EventMetaData.EventMetaDataBuilder;

/**
 * An {@link GenericActionMetaDataEvent} provides Meta-Data describing the
 * {@link GenericActionEvent} in more detail and a source being the origin of
 * the {@link GenericActionMetaDataEvent}.
 *
 * @param <A> The type of the action stored in the event.
 * @param <EM> The type of the EventMetaData
 * @param <SRC> The type of the source in question.
 */
public interface GenericActionMetaDataEvent<A, EM extends EventMetaData, SRC> extends GenericActionEvent<A, SRC>, GenericMetaDataEvent<EM, SRC> {

	/**
	 * Builder extension for the {@link GenericActionMetaDataEvent} type.
	 *
	 * @param <A> The type of the action stored in the event.
	 * @param <EM> The type of the EventMetaData
	 * @param <SRC> The type of the source in question.
	 * @param <B> The type of the builder to be returned by the builder methods.
	 */
	public interface GenericActionMetaDataEventBuilder<A, EM extends EventMetaData, SRC, B extends GenericActionMetaDataEventBuilder<A, EM, SRC, B>> extends GenericActionMetaDataEvent<A, EM, SRC>, MetaDataProperty<EM>, MetaDataBuilder<EM, B>, ActionProperty<A>, ActionBuilder<A, B>, EventMetaDataBuilder {

		/**
		 * {@inheritDoc}
		 */
		@SuppressWarnings("unchecked")
		@Override
		default B withMetaData( EM aMetaData ) {
			setMetaData( aMetaData );
			return (B) this;
		}

		/**
		 * {@inheritDoc}
		 */
		@SuppressWarnings("unchecked")
		@Override
		default B withAction( A aAction ) {
			setAction( aAction );
			return (B) this;
		}

		/**
		 * {@inheritDoc}
		 */
		@SuppressWarnings("unchecked")
		@Override
		default B withPublisherType( Class<?> aPublisherType ) {
			setPublisherType( aPublisherType );
			return (B) this;
		}

		/**
		 * {@inheritDoc}
		 */
		@SuppressWarnings("unchecked")
		@Override
		default B withChannel( String aChannel ) {
			setChannel( aChannel );
			return (B) this;
		}

		/**
		 * {@inheritDoc}
		 */
		@SuppressWarnings("unchecked")
		@Override
		default B withGroup( String aGroup ) {
			setGroup( aGroup );
			return (B) this;
		}

		/**
		 * {@inheritDoc}
		 */
		@SuppressWarnings("unchecked")
		@Override
		default B withAlias( String aAlias ) {
			setAlias( aAlias );
			return (B) this;
		}

		/**
		 * {@inheritDoc}
		 */
		@SuppressWarnings("unchecked")
		@Override
		default B withUniversalId( String aUid ) {
			setUniversalId( aUid );
			return (B) this;
		}

	}

}
