/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.component.OpenException;
import org.refcodes.io.OutputStreamConnectionSenderImpl;
import org.refcodes.io.PrefetchBidirectionalStreamConnectionTransceiverImpl;
import org.refcodes.io.PrefetchInputStreamConnectionReceiverImpl;

public class IoStreamConnectionTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String DATAGRAM_A = "Datagram A";
    private static final String DATAGRAM_B = "Datagram B";

    @Test
    public void testIoStreamTransceiver() throws OpenException, InterruptedException, IOException {
        PipedInputStream theInputStreamA = new PipedInputStream();
        PipedOutputStream theOutputStreamB = new PipedOutputStream(theInputStreamA);
        PipedInputStream theInputStreamB = new PipedInputStream();
        PipedOutputStream theOutputStreamA = new PipedOutputStream(theInputStreamB);
        PrefetchBidirectionalStreamConnectionTransceiverImpl theIoStreamTransceiverA = new PrefetchBidirectionalStreamConnectionTransceiverImpl();
        PrefetchBidirectionalStreamConnectionTransceiverImpl theIoStreamTransceiverB = new PrefetchBidirectionalStreamConnectionTransceiverImpl();
        ObjectOutputStream theObjectOutputStreamA = new ObjectOutputStream(theOutputStreamA);
        theObjectOutputStreamA.flush();
        ObjectOutputStream theObjectOutputStreamB = new ObjectOutputStream(theOutputStreamB);
        theObjectOutputStreamB.flush();
        theIoStreamTransceiverA.open((InputStream)theInputStreamA, (OutputStream)theObjectOutputStreamA);
        theIoStreamTransceiverB.open((InputStream)theInputStreamB, (OutputStream)theObjectOutputStreamB);
        theIoStreamTransceiverA.writeDatagram((Serializable)((Object)DATAGRAM_A));
        String theDatagramA = (String)((Object)theIoStreamTransceiverB.readDatagram());
        if (IS_LOG_TESTS) {
            System.out.println("Transceiver B read datagram \"" + theDatagramA + "\" from transceiver A.");
        }
        Assertions.assertEquals((Object)DATAGRAM_A, (Object)theDatagramA);
        theIoStreamTransceiverB.writeDatagram((Serializable)((Object)DATAGRAM_B));
        String theDatagramB = (String)((Object)theIoStreamTransceiverA.readDatagram());
        if (IS_LOG_TESTS) {
            System.out.println("Transceiver A read datagram \"" + theDatagramB + "\" from transceiver B.");
        }
        Assertions.assertEquals((Object)DATAGRAM_B, (Object)theDatagramB);
        theIoStreamTransceiverA.close();
        theIoStreamTransceiverB.close();
        Assertions.assertTrue((boolean)theIoStreamTransceiverA.isClosed());
        Assertions.assertTrue((boolean)theIoStreamTransceiverB.isClosed());
        try {
            theIoStreamTransceiverA.writeDatagram((Serializable)((Object)DATAGRAM_A));
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (OpenException openException) {
            // empty catch block
        }
        try {
            theIoStreamTransceiverA.readDatagram();
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (OpenException openException) {
            // empty catch block
        }
        try {
            theIoStreamTransceiverB.writeDatagram((Serializable)((Object)DATAGRAM_A));
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (OpenException openException) {
            // empty catch block
        }
        try {
            theIoStreamTransceiverB.readDatagram();
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (OpenException openException) {
            // empty catch block
        }
    }

    @Test
    public void testIoStreamSenderAndReceiver() throws OpenException, InterruptedException, IOException {
        PipedInputStream theInputStream = new PipedInputStream();
        PipedOutputStream theOutputStream = new PipedOutputStream(theInputStream);
        ObjectOutputStream theObjectOutputStream = new ObjectOutputStream(theOutputStream);
        theObjectOutputStream.flush();
        PrefetchInputStreamConnectionReceiverImpl theIoStreamReceiver = new PrefetchInputStreamConnectionReceiverImpl();
        theIoStreamReceiver.open((InputStream)theInputStream);
        OutputStreamConnectionSenderImpl theIoStreamSender = new OutputStreamConnectionSenderImpl();
        theIoStreamSender.open((OutputStream)theObjectOutputStream);
        theIoStreamSender.writeDatagram((Serializable)((Object)DATAGRAM_A));
        theIoStreamSender.writeDatagram((Serializable)((Object)DATAGRAM_B));
        String theDatagram = (String)((Object)theIoStreamReceiver.readDatagram());
        if (IS_LOG_TESTS) {
            System.out.println("Receiver read datagram \"" + theDatagram + "\" from sender.");
        }
        Assertions.assertEquals((Object)DATAGRAM_A, (Object)theDatagram);
        theDatagram = (String)((Object)theIoStreamReceiver.readDatagram());
        if (IS_LOG_TESTS) {
            System.out.println("Receiver read datagram \"" + theDatagram + "\" from sender.");
        }
        Assertions.assertEquals((Object)DATAGRAM_B, (Object)theDatagram);
        theIoStreamSender.close();
        theIoStreamReceiver.close();
        Assertions.assertTrue((boolean)theIoStreamSender.isClosed());
        Assertions.assertTrue((boolean)theIoStreamReceiver.isClosed());
        try {
            theIoStreamSender.writeDatagram((Serializable)((Object)DATAGRAM_A));
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (OpenException openException) {
            // empty catch block
        }
        try {
            theIoStreamReceiver.readDatagram();
            Assertions.fail((String)"Should not reach this code!");
        }
        catch (OpenException openException) {
            // empty catch block
        }
    }
}

