/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipException;
import org.refcodes.tabular.CsvRecordsReader;
import org.refcodes.tabular.Header;

public class ZipFileInputStream
extends BufferedInputStream {
    public ZipFileInputStream(File parent, String child) throws ZipException, FileNotFoundException, IOException {
        this(new File(parent, child));
    }

    public ZipFileInputStream(String parent, String child) throws ZipException, FileNotFoundException, IOException {
        this(new File(parent, child));
    }

    public ZipFileInputStream(String pathname) throws ZipException, FileNotFoundException, IOException {
        this(new File(pathname));
    }

    public ZipFileInputStream(URI uri) throws ZipException, FileNotFoundException, IOException {
        this(new File(uri));
    }

    public ZipFileInputStream(File aFile) throws ZipException, FileNotFoundException, IOException {
        super(ZipFileInputStream.toInputStream(aFile));
    }

    protected static InputStream toInputStream(File aFile) throws ZipException, IOException, FileNotFoundException {
        return ZipFileUtility.toInputStream(aFile);
    }

    protected static String toFileNameFromZip(String aZipFileName) {
        return ZipFileUtility.toFileNameFromZip(aZipFileName);
    }

    private static class ZipFileUtility
    extends CsvRecordsReader {
        private ZipFileUtility(Header aHeader, File aCsvFile) throws FileNotFoundException, IOException, ZipException {
            super(aHeader, aCsvFile);
        }

        protected static InputStream toInputStream(File aFile) throws ZipException, IOException, FileNotFoundException {
            return CsvRecordsReader.toInputStream((File)aFile);
        }

        protected static String toFileNameFromZip(String aZipFileName) {
            return CsvRecordsReader.toFileNameFromZip((String)aZipFileName);
        }
    }
}

