/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.Serializable;
import org.refcodes.component.Closable;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.io.AbstractReceiver;
import org.refcodes.io.Provider;
import org.refcodes.io.Receiver;

public class ReceiverDecorator<DATA extends Serializable>
extends AbstractReceiver<DATA>
implements Receiver<DATA> {
    private Provider<DATA> _provider;
    private boolean _hasReadSuccess = true;

    public ReceiverDecorator(Provider<DATA> aProvider) {
        this._provider = aProvider;
        try {
            this.open();
        }
        catch (OpenException openException) {
            // empty catch block
        }
    }

    @Override
    public DATA readDatagram() throws OpenException, InterruptedException {
        if (!this.isOpened()) {
            throw new OpenException("Cannot read as this receiver is in connection status <" + this.getConnectionStatus() + ">.");
        }
        return this._provider.readDatagram();
    }

    @Override
    public synchronized boolean hasDatagram() throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Cannot read as this receiver is in connection status <" + this.getConnectionStatus() + ">.");
        }
        return this._hasReadSuccess && this.isOpened();
    }

    @Override
    public DATA[] readDatagrams() throws OpenException, InterruptedException {
        if (!this.isOpened()) {
            throw new OpenException("Cannot read as this receiver is in connection status <" + this.getConnectionStatus() + ">.");
        }
        return this._provider.readDatagrams();
    }

    @Override
    public DATA[] readDatagrams(int aBlockSize) throws OpenException, InterruptedException {
        if (!this.isOpened()) {
            throw new OpenException("Cannot read as this receiver is in connection status <" + this.getConnectionStatus() + ">.");
        }
        return this._provider.readDatagrams(aBlockSize);
    }

    @Override
    public void close() throws CloseException {
        if (this._provider instanceof Closable) {
            ((Closable)this._provider).close();
        }
        super.close();
    }
}

