/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Encoding;
import org.refcodes.data.FilenameExtension;
import org.refcodes.data.Scheme;
import org.refcodes.textual.CsvBuilderImpl;
import org.refcodes.textual.CsvEscapeMode;
import org.refcodes.textual.RandomTextGenerartorImpl;
import org.refcodes.textual.RandomTextMode;

public final class FileUtility {
    private FileUtility() {
    }

    public static InputStream getResourceAsStream(Class<?> aClass, String aPath) {
        InputStream theInputStream = aClass.getResourceAsStream(aPath);
        if (theInputStream == null) {
            theInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(aPath);
        }
        if (theInputStream == null) {
            theInputStream = aClass.getClassLoader().getResourceAsStream(aPath);
        }
        return theInputStream;
    }

    public static String toTempFileName() {
        return "temp--" + System.currentTimeMillis() + "-" + ((String)new RandomTextGenerartorImpl().withColumnWidth(8).withRandomTextMode(RandomTextMode.ASCII).next()).toLowerCase() + FilenameExtension.TEMP.getFilenameExtension();
    }

    public static URL createNestedJarFileUrl(URL aJarUrl, File aToDir) throws IOException {
        if (aJarUrl.getProtocol().equals(Scheme.FILE.getName())) {
            return aJarUrl;
        }
        if (!aJarUrl.getProtocol().equals(Scheme.JAR.getName())) {
            return null;
        }
        String theJarPath = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(FileUtility.toJarHierarchy(aJarUrl)).withDelimiter(Delimiter.SYSTEM_FILE_PATH.getChar()).toRecord();
        File theJarDir = new File(aToDir, theJarPath);
        if (!theJarDir.exists() && !theJarDir.mkdirs()) {
            throw new IOException("Failed to create contents directory for archive, path=" + theJarDir.getAbsolutePath());
        }
        JarURLConnection theJarConnection = (JarURLConnection)aJarUrl.openConnection();
        String theEntyName = theJarConnection.getEntryName();
        File theEntryFile = new File(theJarDir, theEntyName);
        if (theEntyName.endsWith("" + Delimiter.PATH)) {
            theEntryFile.mkdirs();
        } else {
            File theJarParentDir = theEntryFile.getParentFile();
            if (!theJarParentDir.exists() && !theJarParentDir.mkdirs()) {
                throw new IOException("Failed to create parent directory for archive, path=" + theJarParentDir.getAbsolutePath());
            }
            try (InputStream theJarInputStream = theJarConnection.getInputStream();
                 BufferedOutputStream theOutputStream = new BufferedOutputStream(new FileOutputStream(theEntryFile));){
                int eRead;
                byte[] theBuffer = new byte[4096];
                while ((eRead = theJarInputStream.read(theBuffer)) > 0) {
                    theOutputStream.write(theBuffer, 0, eRead);
                }
            }
        }
        return theEntryFile.toURI().toURL();
    }

    public static URL getNestedJarFileUrl(URL aJarUrl, File aToDir) throws IOException {
        if (aJarUrl.getProtocol().equals(Scheme.FILE.getName())) {
            return aJarUrl;
        }
        if (!aJarUrl.getProtocol().equals(Scheme.JAR.getName())) {
            return null;
        }
        String theJarPath = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(FileUtility.toJarHierarchy(aJarUrl)).withDelimiter(Delimiter.SYSTEM_FILE_PATH.getChar()).toRecord();
        File theJarDir = new File(aToDir, theJarPath);
        if (!theJarDir.exists()) {
            return null;
        }
        JarURLConnection theJarConnection = (JarURLConnection)aJarUrl.openConnection();
        String theEntyName = theJarConnection.getEntryName();
        File theEntryFile = new File(theJarDir, theEntyName);
        if (!theEntryFile.exists()) {
            return null;
        }
        return theEntryFile.toURI().toURL();
    }

    public static URL toNestedJarFileUrl(URL aJarUrl, File aToDir) throws IOException {
        URL theUrl = FileUtility.getNestedJarFileUrl(aJarUrl, aToDir);
        return theUrl != null ? theUrl : FileUtility.createNestedJarFileUrl(aJarUrl, aToDir);
    }

    public static URL toParentJarUrl() {
        URL theUrl = FileUtility.class.getProtectionDomain().getCodeSource().getLocation();
        if (!theUrl.getProtocol().equals(Scheme.JAR.getName())) {
            return null;
        }
        try {
            String theJarPath = URLDecoder.decode(theUrl.getFile(), Encoding.UTF_8.getCode());
            theJarPath = Scheme.JAR.toUrl(theJarPath);
            return new URL(theJarPath);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            return null;
        }
    }

    public static String[] toJarHierarchy(URL aJarUrl) {
        if (!aJarUrl.getProtocol().equals(Scheme.JAR.getName())) {
            return null;
        }
        ArrayList<String> theList = new ArrayList<String>();
        try {
            String theJarPath = URLDecoder.decode(aJarUrl.getFile(), Encoding.UTF_8.getCode());
            int i = Scheme.JAR.firstMarkerIndex(theJarPath);
            while (i != -1) {
                String eJarFile = theJarPath.substring(0, i);
                int j = eJarFile.lastIndexOf(47);
                if (j != -1) {
                    eJarFile = eJarFile.substring(j + 1);
                }
                theList.add(eJarFile);
                theJarPath = theJarPath.substring(i);
                i = Scheme.JAR.firstMarkerIndex(theJarPath);
            }
            return theList.toArray(new String[theList.size()]);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

