/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import org.refcodes.component.Closable;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.io.AbstractByteReceiver;
import org.refcodes.io.ByteProvider;
import org.refcodes.io.ByteReceiver;

public class ByteReceiverDecorator
extends AbstractByteReceiver
implements ByteReceiver {
    private ByteProvider _byteProvider;
    private boolean _hasReadSuccess = true;

    public ByteReceiverDecorator(ByteProvider aByteProvider) {
        this._byteProvider = aByteProvider;
        try {
            this.open();
        }
        catch (OpenException openException) {
            // empty catch block
        }
    }

    @Override
    public byte readDatagram() throws OpenException, InterruptedException {
        if (!this.isOpened()) {
            throw new OpenException("Cannot read as this receiver is in connection status <" + this.getConnectionStatus() + ">.");
        }
        return this._byteProvider.readDatagram();
    }

    @Override
    public synchronized boolean hasDatagram() throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Cannot read as this receiver is in connection status <" + this.getConnectionStatus() + ">.");
        }
        return this._hasReadSuccess && this.isOpened();
    }

    @Override
    public byte[] readDatagrams() throws OpenException, InterruptedException {
        if (!this.isOpened()) {
            throw new OpenException("Cannot read as this receiver is in connection status <" + this.getConnectionStatus() + ">.");
        }
        return this._byteProvider.readDatagrams();
    }

    @Override
    public byte[] readDatagrams(int aBlockSize) throws OpenException, InterruptedException {
        if (!this.isOpened()) {
            throw new OpenException("Cannot read as this receiver is in connection status <" + this.getConnectionStatus() + ">.");
        }
        return this._byteProvider.readDatagrams(aBlockSize);
    }

    @Override
    public void close() throws CloseException {
        if (this._byteProvider instanceof Closable) {
            ((Closable)this._byteProvider).close();
        }
        super.close();
    }
}

