/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.CloseException;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryTimeoutImpl;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.RetryLoopCount;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.io.AbstractByteReceiver;
import org.refcodes.io.SerializableObjectInputStreamImpl;
import org.refcodes.mixin.Disposable;
import org.refcodes.mixin.Loggable;

public abstract class AbstractPrefetchInputStreamByteReceiver
extends AbstractByteReceiver
implements Loggable {
    private ObjectInputStream _objectInputStream = null;
    private ExecutorService _executorService;
    private IoStreamReceiverDaemon _ioStreamReceiverDaemon = null;
    private boolean _isDaemonAlive = false;

    public AbstractPrefetchInputStreamByteReceiver() {
        this(1024, null);
    }

    public AbstractPrefetchInputStreamByteReceiver(ExecutorService aExecutorService) {
        this(1024, aExecutorService);
    }

    public AbstractPrefetchInputStreamByteReceiver(int aQueueCapacity) {
        this(aQueueCapacity, null);
    }

    public AbstractPrefetchInputStreamByteReceiver(int aQueueCapacity, ExecutorService aExecutorService) {
        this._executorService = aExecutorService == null ? ControlFlowUtility.createCachedExecutorService((boolean)true) : ControlFlowUtility.toManagedExecutorService((ExecutorService)aExecutorService);
    }

    @Override
    public synchronized void close() throws CloseException {
        if (!this.isClosed()) {
            super.close();
            if (this._ioStreamReceiverDaemon != null) {
                this._ioStreamReceiverDaemon.dispose();
                this._ioStreamReceiverDaemon = null;
            }
            try {
                if (this._objectInputStream != null) {
                    this._objectInputStream.close();
                }
            }
            catch (IOException e) {
                throw new CloseException("Unable to close receiver, connection status is <" + this.getConnectionStatus() + ">.", (Throwable)e);
            }
        }
    }

    protected synchronized void open(InputStream aInputStream) throws OpenException {
        block5: {
            if (this.isOpened()) {
                throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
            }
            try {
                this._objectInputStream = !(aInputStream instanceof BufferedInputStream) ? new SerializableObjectInputStreamImpl(new BufferedInputStream(aInputStream)) : new SerializableObjectInputStreamImpl(aInputStream);
            }
            catch (IOException aException) {
                if (ExceptionUtility.isThrownAsOfAlreadyClosed((IOException)aException)) break block5;
                throw new OpenException("Unable to open the I/O stream receiver as of a causing exception.", (Throwable)aException);
            }
        }
        this._ioStreamReceiverDaemon = new IoStreamReceiverDaemon();
        this.setConnectionStatus(ConnectionStatus.OPENED);
        this._executorService.execute(this._ioStreamReceiverDaemon);
        if (!this._isDaemonAlive) {
            RetryTimeoutImpl theRetryTimeout = new RetryTimeoutImpl((long)DaemonLoopSleepTime.NORM.getMilliseconds(), RetryLoopCount.NORM_NUM_RETRY_LOOPS.getNumber().intValue());
            while (!this._isDaemonAlive) {
                theRetryTimeout.nextRetry();
            }
        }
    }

    protected boolean isOpenable(InputStream aInputStream) {
        if (aInputStream == null) {
            return false;
        }
        return !this.isOpened();
    }

    private class IoStreamReceiverDaemon
    implements Runnable,
    Disposable {
        private boolean _isDisposed = false;

        private IoStreamReceiverDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AbstractPrefetchInputStreamByteReceiver.this._isDaemonAlive = true;
                while (!this._isDisposed && AbstractPrefetchInputStreamByteReceiver.this.isOpened()) {
                    int eWord = AbstractPrefetchInputStreamByteReceiver.this._objectInputStream.read();
                    AbstractPrefetchInputStreamByteReceiver.this.pushDatagram((byte)(eWord & 0xFF));
                }
            }
            catch (IOException aException) {
                AbstractPrefetchInputStreamByteReceiver abstractPrefetchInputStreamByteReceiver = AbstractPrefetchInputStreamByteReceiver.this;
                synchronized (abstractPrefetchInputStreamByteReceiver) {
                    if (AbstractPrefetchInputStreamByteReceiver.this.isOpened()) {
                        try {
                            if (!(aException instanceof EOFException)) {
                                AbstractPrefetchInputStreamByteReceiver.this.warn("Unable to read datagram from sender as of a causing exception; connection status is " + AbstractPrefetchInputStreamByteReceiver.this.getConnectionStatus(), aException);
                            }
                            AbstractPrefetchInputStreamByteReceiver.this.close();
                        }
                        catch (CloseException e) {
                            AbstractPrefetchInputStreamByteReceiver.this.warn("Unable to close malfunctioning connection as of: " + ExceptionUtility.toMessage((Throwable)e), e);
                        }
                    }
                }
            }
            finally {
                AbstractPrefetchInputStreamByteReceiver.this._isDaemonAlive = false;
            }
        }

        public void dispose() {
            this._isDisposed = true;
        }
    }
}

