package org.refcodes.io;

import java.util.List;

import org.refcodes.component.OpenException;

/**
 * The Class ByteArrayProviderImpl.
 */
public class ByteArrayProviderImpl extends AbstractByteProvider implements ByteArrayProvider {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new byte array provider impl.
	 *
	 * @param aDatagrams the datagrams
	 */
	public ByteArrayProviderImpl( byte[] aDatagrams ) {
		super( aDatagrams.length );
		try {
			pushDatagrams( aDatagrams );
		}
		catch ( OpenException ignore ) {}
	}

	/**
	 * Instantiates a new byte array provider impl.
	 *
	 * @param aDatagrams the datagrams
	 */
	public ByteArrayProviderImpl( List<Byte> aDatagrams ) {
		this( toPrimitiveType( aDatagrams.toArray( new Byte[aDatagrams.size()] ) ) );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public byte[] getBytes() {
		return toPrimitiveType( _datagramQueue.toArray( new Byte[_datagramQueue.size()] ) );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	private static byte[] toPrimitiveType( Byte[] aBytes ) {
		if ( aBytes == null ) return null;
		byte[] thePrimitives = new byte[aBytes.length];
		for ( int i = 0; i < aBytes.length; i++ ) {
			thePrimitives[i] = aBytes[i].byteValue();
		}
		return thePrimitives;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
