/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Delimiter;
import org.refcodes.io.FileUtility;
import org.refcodes.io.ZipFileInputStreamImpl;
import org.refcodes.io.ZipFileOutputStreamImpl;
import org.refcodes.textual.CsvBuilderImpl;
import org.refcodes.textual.CsvEscapeMode;

public class ZipFileStreamTest {
    private static final String ZIP_FILE_MAGIC_BYTES = "PK";
    private static final boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String[][] ZIP_FILE_NAMES = new String[][]{{"test.log.zip", "test.log"}, {"test.log.ZIP", "test.log"}, {"home/user/test.log.zip", "home/user/test.log"}, {".zip", ""}};

    @Test
    public void toAutoDetectInputStream() {
        for (int i = 0; i < ZIP_FILE_NAMES.length; ++i) {
            if (IS_LOG_TESTS) {
                System.out.println("In:      \"" + ZIP_FILE_NAMES[i][0] + "\"");
            }
            if (IS_LOG_TESTS) {
                System.out.println("Out:     \"" + ZipFileInputStreamImpl.toFileNameFromZip((String)ZIP_FILE_NAMES[i][0]) + "\"");
            }
            if (IS_LOG_TESTS) {
                System.out.println("Expected:\"" + ZIP_FILE_NAMES[i][1] + "\"");
            }
            Assertions.assertEquals((Object)ZIP_FILE_NAMES[i][1], (Object)ZipFileInputStreamImpl.toFileNameFromZip((String)ZIP_FILE_NAMES[i][0]));
        }
    }

    @Test
    public void toJarHierarchy() throws MalformedURLException {
        URL theJarPath1 = new URL("jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml");
        URL theJarPath2 = new URL("jar:file:/home/steiner/Workspaces/com.fightclub/fightclub-app/target/fightclub-app-0.0.1-SNAPSHOT.jar!/lib/fightclub-adapter-web-0.0.1-SNAPSHOT.jar!/webapp/home.xhtml");
        String[] theJarHierarchy = FileUtility.toJarHierarchy((URL)theJarPath1);
        String theJarPath = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(theJarHierarchy).withDelimiterChar(Delimiter.PATH.getChar()).toRecord();
        if (IS_LOG_TESTS) {
            System.out.println("JAR parh 1 := " + theJarPath);
        }
        Assertions.assertEquals((Object)"fightclub-app-0.0.1-SNAPSHOT.jar", (Object)theJarPath);
        theJarHierarchy = FileUtility.toJarHierarchy((URL)theJarPath2);
        theJarPath = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(theJarHierarchy).withDelimiterChar(Delimiter.PATH.getChar()).toRecord();
        if (IS_LOG_TESTS) {
            System.out.println("JAR parh 2 := " + theJarPath);
        }
        Assertions.assertEquals((Object)"fightclub-app-0.0.1-SNAPSHOT.jar/fightclub-adapter-web-0.0.1-SNAPSHOT.jar", (Object)theJarPath);
    }

    @Test
    public void testZipFile() throws ZipException, FileNotFoundException, IOException {
        String theText = "The class <" + this.getClass().getName() + "> says: \"Hello World!\"";
        File theZipFile = File.createTempFile("refcodes-", ".zip");
        theZipFile.deleteOnExit();
        ZipFileOutputStreamImpl theZipOut = new ZipFileOutputStreamImpl(theZipFile);
        theZipOut.write(theText.getBytes());
        theZipOut.close();
        ZipFileInputStreamImpl theZipIn = new ZipFileInputStreamImpl(theZipFile);
        String theZipData = this.toString((InputStream)theZipIn);
        theZipIn.close();
        Assertions.assertEquals((Object)theText, (Object)theZipData);
        FileInputStream theRawIn = new FileInputStream(theZipFile);
        String theRawData = this.toString(theRawIn);
        ((InputStream)theRawIn).close();
        Assertions.assertNotEquals((Object)theZipData, (Object)theRawData);
        Assertions.assertEquals((Object)ZIP_FILE_MAGIC_BYTES, (Object)theRawData.substring(0, 2));
    }

    private String toString(InputStream theZipIn) throws IOException {
        StringBuffer theBuffer = new StringBuffer();
        int eByte = theZipIn.read();
        while (eByte != -1) {
            theBuffer.append(new String(new byte[]{(byte)eByte}));
            eByte = theZipIn.read();
        }
        return theBuffer.toString();
    }
}

