/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.Serializable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.io.LoopbackByteReceiver;
import org.refcodes.io.LoopbackByteReceiverImpl;
import org.refcodes.io.LoopbackByteSender;
import org.refcodes.io.LoopbackByteSenderImpl;
import org.refcodes.io.LoopbackReceiver;
import org.refcodes.io.LoopbackReceiverImpl;
import org.refcodes.io.LoopbackSender;
import org.refcodes.io.LoopbackSenderImpl;
import org.refcodes.io.LoopbackShortReceiver;
import org.refcodes.io.LoopbackShortReceiverImpl;
import org.refcodes.io.LoopbackShortSender;
import org.refcodes.io.LoopbackShortSenderImpl;
import org.refcodes.io.LoopbackTransceiver;
import org.refcodes.io.LoopbackTransceiverImpl;

public class LoopbackConnectionTest {
    private static final boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String DATAGRAM_A = "Datagram A";
    private static final String DATAGRAM_B = "Datagram B";

    @Test
    public void testLoopbackTransceiver() throws OpenException, InterruptedException, CloseException {
        for (int i = 0; i < 2; ++i) {
            LoopbackTransceiverImpl theLoopbackTransceiverA = new LoopbackTransceiverImpl();
            LoopbackTransceiverImpl theLoopbackTransceiverB = new LoopbackTransceiverImpl();
            theLoopbackTransceiverA.open((LoopbackTransceiver)theLoopbackTransceiverB);
            theLoopbackTransceiverB.open((LoopbackTransceiver)theLoopbackTransceiverA);
            theLoopbackTransceiverA.writeDatagram((Serializable)((Object)DATAGRAM_A));
            String theDatagramA = (String)((Object)theLoopbackTransceiverB.readDatagram());
            if (IS_LOG_TESTS) {
                System.out.println("Transceiver B read datagram \"" + theDatagramA + "\" from transceiver A.");
            }
            Assertions.assertEquals((Object)DATAGRAM_A, (Object)theDatagramA);
            theLoopbackTransceiverB.writeDatagram((Serializable)((Object)DATAGRAM_B));
            String theDatagramB = (String)((Object)theLoopbackTransceiverA.readDatagram());
            if (IS_LOG_TESTS) {
                System.out.println("Transceiver A read datagram \"" + theDatagramB + "\" from transceiver B.");
            }
            Assertions.assertEquals((Object)DATAGRAM_B, (Object)theDatagramB);
            if (i == 0) {
                if (IS_LOG_TESTS) {
                    System.out.println("Closing transceiver A.");
                }
                theLoopbackTransceiverA.close();
                Assertions.assertTrue((boolean)theLoopbackTransceiverA.isClosed());
            }
            if (i == 1) {
                if (IS_LOG_TESTS) {
                    System.out.println("Closing transceiver B.");
                }
                theLoopbackTransceiverB.close();
                Assertions.assertTrue((boolean)theLoopbackTransceiverB.isClosed());
            }
            try {
                theLoopbackTransceiverA.writeDatagram((Serializable)((Object)DATAGRAM_A));
                Assertions.fail((String)"Should not reach this code!");
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackTransceiverA.readDatagram();
                Assertions.fail((String)"Should not reach this code!");
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackTransceiverB.writeDatagram((Serializable)((Object)DATAGRAM_A));
                Assertions.fail((String)"Should not reach this code!");
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackTransceiverB.readDatagram();
                Assertions.fail((String)"Should not reach this code!");
                continue;
            }
            catch (OpenException openException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLoopbackSenderAndReceiver() throws OpenException, InterruptedException, CloseException {
        for (int i = 0; i < 2; ++i) {
            LoopbackReceiverImpl theLoopbackReceiver = new LoopbackReceiverImpl();
            LoopbackSenderImpl theLoopbackSender = new LoopbackSenderImpl();
            theLoopbackReceiver.open((LoopbackSender)theLoopbackSender);
            theLoopbackSender.open((LoopbackReceiver)theLoopbackReceiver);
            theLoopbackSender.writeDatagram((Serializable)((Object)DATAGRAM_A));
            theLoopbackSender.writeDatagram((Serializable)((Object)DATAGRAM_B));
            String theDatagram = (String)((Object)theLoopbackReceiver.readDatagram());
            if (IS_LOG_TESTS) {
                System.out.println("Receiver read datagram \"" + theDatagram + "\" from sender.");
            }
            Assertions.assertEquals((Object)DATAGRAM_A, (Object)theDatagram);
            theDatagram = (String)((Object)theLoopbackReceiver.readDatagram());
            if (IS_LOG_TESTS) {
                System.out.println("Receiver read datagram \"" + theDatagram + "\" from sender.");
            }
            Assertions.assertEquals((Object)DATAGRAM_B, (Object)theDatagram);
            if (i == 0) {
                if (IS_LOG_TESTS) {
                    System.out.println("Closing sender.");
                }
                theLoopbackSender.close();
                Assertions.assertTrue((boolean)theLoopbackSender.isClosed());
            }
            if (i == 1) {
                if (IS_LOG_TESTS) {
                    System.out.println("Closing receiver.");
                }
                theLoopbackReceiver.close();
                Assertions.assertTrue((boolean)theLoopbackReceiver.isClosed());
            }
            try {
                theLoopbackSender.writeDatagram((Serializable)((Object)DATAGRAM_A));
                Assertions.fail((String)"Should not reach this code!");
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackReceiver.readDatagram();
                Assertions.fail((String)"Should not reach this code!");
                continue;
            }
            catch (OpenException openException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLoopbackByteSenderAndReceiver() throws OpenException, InterruptedException, CloseException {
        for (int i = 0; i < 2; ++i) {
            LoopbackByteReceiverImpl theLoopbackReceiver = new LoopbackByteReceiverImpl();
            LoopbackByteSenderImpl theLoopbackSender = new LoopbackByteSenderImpl();
            theLoopbackReceiver.open((LoopbackByteSender)theLoopbackSender);
            theLoopbackSender.open((LoopbackByteReceiver)theLoopbackReceiver);
            theLoopbackSender.writeDatagrams(DATAGRAM_A.getBytes());
            theLoopbackSender.writeDatagrams(DATAGRAM_B.getBytes());
            String theDatagram = new String(theLoopbackReceiver.readDatagrams(DATAGRAM_A.getBytes().length));
            if (IS_LOG_TESTS) {
                System.out.println("Receiver read datagram \"" + theDatagram + "\" from sender.");
            }
            Assertions.assertEquals((Object)DATAGRAM_A, (Object)theDatagram);
            theDatagram = new String(theLoopbackReceiver.readDatagrams(DATAGRAM_B.getBytes().length));
            if (IS_LOG_TESTS) {
                System.out.println("Receiver read datagram \"" + theDatagram + "\" from sender.");
            }
            Assertions.assertEquals((Object)DATAGRAM_B, (Object)theDatagram);
            if (i == 0) {
                if (IS_LOG_TESTS) {
                    System.out.println("Closing sender.");
                }
                theLoopbackSender.close();
                Assertions.assertTrue((boolean)theLoopbackSender.isClosed());
            }
            if (i == 1) {
                if (IS_LOG_TESTS) {
                    System.out.println("Closing receiver.");
                }
                theLoopbackReceiver.close();
                Assertions.assertTrue((boolean)theLoopbackReceiver.isClosed());
            }
            try {
                theLoopbackSender.writeDatagrams(DATAGRAM_A.getBytes());
                Assertions.fail((String)"Should not reach this code!");
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackReceiver.readDatagram();
                Assertions.fail((String)"Should not reach this code!");
                continue;
            }
            catch (OpenException openException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testLoopbackShortSenderAndReceiver() throws OpenException, InterruptedException, CloseException {
        for (int i = 0; i < 2; ++i) {
            LoopbackShortReceiverImpl theLoopbackReceiver = new LoopbackShortReceiverImpl();
            LoopbackShortSenderImpl theLoopbackSender = new LoopbackShortSenderImpl();
            theLoopbackReceiver.open((LoopbackShortSender)theLoopbackSender);
            theLoopbackSender.open((LoopbackShortReceiver)theLoopbackReceiver);
            theLoopbackSender.writeDatagram((short)51);
            theLoopbackSender.writeDatagram((short)61);
            short theDatagram = theLoopbackReceiver.readDatagram();
            if (IS_LOG_TESTS) {
                System.out.println("Receiver read datagram \"" + theDatagram + "\" from sender.");
            }
            Assertions.assertEquals((int)51, (int)theDatagram);
            theDatagram = theLoopbackReceiver.readDatagram();
            if (IS_LOG_TESTS) {
                System.out.println("Receiver read datagram \"" + theDatagram + "\" from sender.");
            }
            Assertions.assertEquals((int)61, (int)theDatagram);
            if (i == 0) {
                if (IS_LOG_TESTS) {
                    System.out.println("Closing sender.");
                }
                theLoopbackSender.close();
                Assertions.assertTrue((boolean)theLoopbackSender.isClosed());
            }
            if (i == 1) {
                if (IS_LOG_TESTS) {
                    System.out.println("Closing receiver.");
                }
                theLoopbackReceiver.close();
                Assertions.assertTrue((boolean)theLoopbackReceiver.isClosed());
            }
            try {
                theLoopbackSender.writeDatagram((short)51);
                Assertions.fail((String)"Should not reach this code!");
            }
            catch (OpenException openException) {
                // empty catch block
            }
            try {
                theLoopbackReceiver.readDatagram();
                Assertions.fail((String)"Should not reach this code!");
                continue;
            }
            catch (OpenException openException) {
                // empty catch block
            }
        }
    }
}

