/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.component.OpenException;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.io.ShortBlockReceiver;
import org.refcodes.io.ShortDatagramReceiver;
import org.refcodes.io.ShortProvider;

public interface ShortReceiver
extends ShortProvider,
ShortDatagramReceiver,
ShortBlockReceiver {
    @Override
    default public short[] readDatagrams() throws OpenException, InterruptedException {
        ArrayList<Short> theData = new ArrayList<Short>();
        while (this.hasDatagram()) {
            theData.add(this.readDatagram());
        }
        short[] theShorts = new short[theData.size()];
        for (int i = 0; i < theShorts.length; ++i) {
            theShorts[i] = (Short)theData.get(i);
        }
        return theShorts;
    }

    @Override
    default public short[] readDatagrams(int aBlockSize) throws OpenException, InterruptedException {
        int i;
        short[] theBlock = new short[aBlockSize];
        for (i = 0; this.hasDatagram() && i < aBlockSize; ++i) {
            theBlock[i] = this.readDatagram();
        }
        if (i == 0) {
            while (!this.hasDatagram()) {
                Thread.sleep(LoopSleepTime.NORM.getMilliseconds());
                while (this.hasDatagram() && i < aBlockSize) {
                    theBlock[i] = this.readDatagram();
                    ++i;
                }
            }
        }
        if (i == aBlockSize) {
            return theBlock;
        }
        return Arrays.copyOfRange(theBlock, 0, i);
    }
}

