/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.component.OpenException;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.io.BlockReceiver;
import org.refcodes.io.DatagramReceiver;
import org.refcodes.io.Provider;

public interface Receiver<DATA extends Serializable>
extends Provider<DATA>,
DatagramReceiver<DATA>,
BlockReceiver<DATA> {
    @Override
    default public DATA[] readDatagrams() throws OpenException, InterruptedException {
        ArrayList theData = new ArrayList();
        while (this.hasDatagram()) {
            theData.add(this.readDatagram());
        }
        return theData.toArray((Serializable[])new Object[theData.size()]);
    }

    @Override
    default public DATA[] readDatagrams(int aBlockSize) throws OpenException, InterruptedException {
        int i;
        Serializable[] theBlock = (Serializable[])new Object[aBlockSize];
        for (i = 0; this.hasDatagram() && i < aBlockSize; ++i) {
            theBlock[i] = this.readDatagram();
        }
        if (i == 0) {
            while (!this.hasDatagram()) {
                Thread.sleep(LoopSleepTime.NORM.getMilliseconds());
                while (this.hasDatagram() && i < aBlockSize) {
                    theBlock[i] = this.readDatagram();
                    ++i;
                }
            }
        }
        if (i == aBlockSize) {
            return theBlock;
        }
        return Arrays.copyOfRange(theBlock, 0, i);
    }
}

