/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.io.AbstractPrefetchInputStreamByteReceiver;
import org.refcodes.io.BidirectionalStreamConnectionByteTransceiver;

public class PrefetchBidirectionalStreamConnectionByteTransceiverImpl
extends AbstractPrefetchInputStreamByteReceiver
implements BidirectionalStreamConnectionByteTransceiver {
    private ObjectOutputStream _objectOutputStream = null;

    public boolean isOpenable(InputStream aInputStream, OutputStream aOutputStream) {
        if (aOutputStream == null) {
            return false;
        }
        return this.isOpenable(aInputStream);
    }

    public void open(InputStream aInputStream, OutputStream aOutputStream) throws OpenException {
        this.open(aOutputStream);
        this.open(aInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDatagram(byte aDatagram) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagram + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        ObjectOutputStream objectOutputStream = this._objectOutputStream;
        synchronized (objectOutputStream) {
            try {
                this._objectOutputStream.writeObject(aDatagram);
                this._objectOutputStream.flush();
            }
            catch (IOException aException) {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.close();
                }
                catch (CloseException e) {
                    throw new OpenException("Unable to close malfunctioning stream.", (Throwable)e);
                }
                throw new OpenException((Throwable)aException);
            }
        }
    }

    @Override
    public void flush() throws OpenException {
        try {
            this._objectOutputStream.flush();
        }
        catch (IOException e) {
            throw new OpenException("Unable to flush transceiver's output stream <" + this._objectOutputStream + ">.", (Throwable)e);
        }
    }

    @Override
    public synchronized void close() throws CloseException {
        block2: {
            super.close();
            try {
                this._objectOutputStream.close();
            }
            catch (IOException aException) {
                if (ExceptionUtility.isThrownAsOfAlreadyClosed((IOException)aException)) break block2;
                throw new CloseException("Unable to close stream <" + this._objectOutputStream + ">.", (Throwable)aException);
            }
        }
    }

    protected synchronized void open(OutputStream aOutputStream) throws OpenException {
        if (this.isOpened()) {
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        try {
            this._objectOutputStream = aOutputStream instanceof ObjectOutputStream ? (ObjectOutputStream)aOutputStream : (!(aOutputStream instanceof BufferedOutputStream) ? new ObjectOutputStream(new BufferedOutputStream(aOutputStream)) : new ObjectOutputStream(aOutputStream));
            this._objectOutputStream.flush();
        }
        catch (IOException aException) {
            throw new OpenException("Unable to open the I/O stream receiver as of a causing exception.", (Throwable)aException);
        }
    }
}

