/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.Serializable;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.io.AbstractReceiver;
import org.refcodes.io.LoopbackTransceiver;

public class LoopbackTransceiverImpl<DATA extends Serializable>
extends AbstractReceiver<DATA>
implements LoopbackTransceiver<DATA> {
    private LoopbackTransceiver<DATA> _loopbackTransceiver = null;

    public LoopbackTransceiverImpl() {
    }

    public LoopbackTransceiverImpl(int aCapacity) {
        super(aCapacity);
    }

    public boolean isOpenable(LoopbackTransceiver<DATA> aLoopbackTransceiver) {
        return !this.isOpened() && aLoopbackTransceiver != null;
    }

    public synchronized void open(LoopbackTransceiver<DATA> aLoopbackTransceiver) throws OpenException {
        if (this.isOpened()) {
            if (this._loopbackTransceiver == aLoopbackTransceiver && this._loopbackTransceiver.isOpened()) {
                return;
            }
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        super.open();
        this._loopbackTransceiver = aLoopbackTransceiver;
        if (this._loopbackTransceiver.isOpenable(this)) {
            this._loopbackTransceiver.open(this);
        }
    }

    @Override
    public void writeDatagram(DATA aDatagram) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagram.getClass().getName() + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackTransceiver.pushDatagram(aDatagram);
    }

    @Override
    public void pushDatagram(DATA aDatagram) throws OpenException {
        super.pushDatagram(aDatagram);
    }

    @Override
    public void flush() throws OpenException {
        this._loopbackTransceiver.flush();
    }

    @Override
    public synchronized void close() throws CloseException {
        super.close();
        if (this._loopbackTransceiver != null && !this._loopbackTransceiver.isClosed()) {
            this._loopbackTransceiver.close();
            this._loopbackTransceiver = null;
        }
    }
}

