/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.io.AbstractShortSender;
import org.refcodes.io.LoopbackShortReceiver;
import org.refcodes.io.LoopbackShortSender;

public class LoopbackShortSenderImpl
extends AbstractShortSender
implements LoopbackShortSender {
    private LoopbackShortReceiver _loopbackReceiver;

    public boolean isOpenable(LoopbackShortReceiver aLoopbackReceiver) {
        return !this.isOpened() && aLoopbackReceiver != null;
    }

    public synchronized void open(LoopbackShortReceiver aLoopbackReceiver) throws OpenException {
        if (this.isOpened()) {
            if (this._loopbackReceiver == aLoopbackReceiver && this._loopbackReceiver.isOpened()) {
                return;
            }
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        super.open();
        this._loopbackReceiver = aLoopbackReceiver;
        if (this._loopbackReceiver.isOpenable(this)) {
            this._loopbackReceiver.open(this);
        }
    }

    @Override
    public synchronized void writeDatagram(short aDatagram) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagram + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagram(aDatagram);
    }

    @Override
    public void writeDatagrams(short[] aDatagrams, int aOffset, int aLength) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagrams + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagrams(aDatagrams, aOffset, aLength);
    }

    @Override
    public void writeDatagrams(short[] aDatagrams) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagrams + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagrams(aDatagrams);
    }

    @Override
    public void flush() throws OpenException {
    }

    public void close() throws CloseException {
        super.close();
        if (this._loopbackReceiver != null && !this._loopbackReceiver.isClosed()) {
            this._loopbackReceiver.close();
            this._loopbackReceiver = null;
        }
    }
}

