/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.Serializable;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.io.AbstractSender;
import org.refcodes.io.LoopbackReceiver;
import org.refcodes.io.LoopbackSender;

public class LoopbackSenderImpl<DATA extends Serializable>
extends AbstractSender<DATA>
implements LoopbackSender<DATA> {
    private LoopbackReceiver<DATA> _loopbackReceiver;

    public boolean isOpenable(LoopbackReceiver<DATA> aLoopbackReceiver) {
        return !this.isOpened() && aLoopbackReceiver != null;
    }

    public synchronized void open(LoopbackReceiver<DATA> aLoopbackReceiver) throws OpenException {
        if (this.isOpened()) {
            if (this._loopbackReceiver == aLoopbackReceiver && this._loopbackReceiver.isOpened()) {
                return;
            }
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        super.open();
        this._loopbackReceiver = aLoopbackReceiver;
        if (this._loopbackReceiver.isOpenable(this)) {
            this._loopbackReceiver.open(this);
        }
    }

    @Override
    public synchronized void writeDatagram(DATA aDatagram) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagram.getClass().getName() + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagram(aDatagram);
    }

    @Override
    public void writeDatagrams(DATA[] aDatagrams, int aOffset, int aLength) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagrams + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagrams((Serializable[])aDatagrams, aOffset, aLength);
    }

    @Override
    public void writeDatagrams(DATA[] aDatagrams) throws OpenException {
        if (!this.isOpened()) {
            throw new OpenException("Unable to write datagram <" + aDatagrams + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagrams((Serializable[])aDatagrams);
    }

    @Override
    public void flush() throws OpenException {
    }

    public void close() throws CloseException {
        super.close();
        if (this._loopbackReceiver != null && !this._loopbackReceiver.isClosed()) {
            this._loopbackReceiver.close();
            this._loopbackReceiver = null;
        }
    }
}

