/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io.impls;

import java.io.Serializable;
import org.refcodes.component.CloseException;
import org.refcodes.component.OpenException;
import org.refcodes.io.LoopbackConnectionReceiver;
import org.refcodes.io.LoopbackConnectionSender;
import org.refcodes.io.impls.AbstractReceiver;

public class LoopbackReceiverImpl<DATA extends Serializable>
extends AbstractReceiver<DATA>
implements LoopbackConnectionReceiver<DATA> {
    private LoopbackConnectionSender<DATA> _loopbackSender;

    public LoopbackReceiverImpl() {
    }

    public LoopbackReceiverImpl(int aCapacity) {
        super(aCapacity);
    }

    public boolean isOpenable(LoopbackConnectionSender<DATA> aLoopbackSender) {
        return super.isOpenable() && aLoopbackSender != null;
    }

    public synchronized void open(LoopbackConnectionSender<DATA> aLoopbackSender) throws OpenException {
        if (this.isOpened()) {
            if (this._loopbackSender == aLoopbackSender && this._loopbackSender.isOpened()) {
                return;
            }
            throw new OpenException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        super.open();
        this._loopbackSender = aLoopbackSender;
        if (this._loopbackSender.isOpenable(this)) {
            this._loopbackSender.open(this);
        }
    }

    @Override
    public void pushDatagram(DATA aDatagram) throws OpenException {
        super.pushDatagram(aDatagram);
    }

    @Override
    public synchronized void close() throws CloseException {
        super.close();
        if (this._loopbackSender != null && !this._loopbackSender.isClosed()) {
            this._loopbackSender.close();
            this._loopbackSender = null;
        }
    }
}

