/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LocalCachedMapUpdate
implements Serializable {
    private List<Entry> entries = new ArrayList<Entry>();
    private byte[] excludedId;

    public LocalCachedMapUpdate() {
    }

    public LocalCachedMapUpdate(byte[] excludedId, List<Entry> entries) {
        this.excludedId = excludedId;
        this.entries = entries;
    }

    public LocalCachedMapUpdate(byte[] excludedId, ByteBuf keyBuf, ByteBuf valueBuf) {
        this.excludedId = excludedId;
        byte[] key = new byte[keyBuf.readableBytes()];
        keyBuf.getBytes(keyBuf.readerIndex(), key);
        byte[] value = new byte[valueBuf.readableBytes()];
        valueBuf.getBytes(valueBuf.readerIndex(), value);
        this.entries = Collections.singletonList(new Entry(key, value));
    }

    public LocalCachedMapUpdate(byte[] key, byte[] value) {
        this.entries = Collections.singletonList(new Entry(key, value));
    }

    public Collection<Entry> getEntries() {
        return this.entries;
    }

    public byte[] getExcludedId() {
        return this.excludedId;
    }

    public static class Entry {
        private final byte[] key;
        private final byte[] value;

        public Entry(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public Entry(ByteBuf keyBuf, ByteBuf valueBuf) {
            this.key = new byte[keyBuf.readableBytes()];
            keyBuf.getBytes(keyBuf.readerIndex(), this.key);
            this.value = new byte[valueBuf.readableBytes()];
            valueBuf.getBytes(valueBuf.readerIndex(), this.value);
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }
    }
}

