/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;
import org.redisson.misc.FastRemovalQueue;

public class LRUCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final FastRemovalQueue<CachedValue<K, V>> queue = new FastRemovalQueue();

    public LRUCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        super(size, timeToLiveInMillis, maxIdleInMillis);
    }

    @Override
    protected void onValueCreate(CachedValue<K, V> value) {
        this.queue.add(value);
    }

    @Override
    protected void onValueRemove(CachedValue<K, V> value) {
        this.queue.remove(value);
        super.onValueRemove(value);
    }

    @Override
    protected void onValueRead(CachedValue<K, V> value) {
        this.queue.moveToTail(value);
    }

    @Override
    protected void onMapFull() {
        CachedValue<K, V> removedValue = this.queue.poll();
        if (removedValue != null && this.map.remove(removedValue.getKey(), removedValue)) {
            super.onValueRemove(removedValue);
        }
    }

    @Override
    public void clear() {
        this.queue.clear();
        super.clear();
    }
}

