/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.rapidoid.cls.Cls;
import org.rapidoid.config.ConfigEntry;
import org.rapidoid.u.U;

public class Config {
    private final Map<String, Object> properties;

    public Config(Map<String, Object> configProperties) {
        this.properties = Collections.synchronizedMap(configProperties);
    }

    public Config() {
        this(U.map());
    }

    public String option(String name) {
        Object opt = this.properties.get(name);
        return opt != null ? U.str((Object)opt) : null;
    }

    public String option(String name, String defaultValue) {
        Object obj = this.properties.get(name);
        return obj != null ? U.str((Object)obj) : defaultValue;
    }

    public int option(String name, int defaultValue) {
        String n = this.option(name);
        return n != null ? U.num((String)n) : defaultValue;
    }

    public long option(String name, long defaultValue) {
        String n = this.option(name);
        return n != null ? Long.parseLong(n) : defaultValue;
    }

    public double option(String name, double defaultValue) {
        String n = this.option(name);
        return n != null ? Double.parseDouble(n) : defaultValue;
    }

    public boolean has(String name, Object value) {
        Object val = this.properties.get(name);
        return U.eq((Object)val, (Object)value);
    }

    public boolean has(String name) {
        return this.properties.containsKey(name);
    }

    public boolean is(String name) {
        return this.has(name, true);
    }

    public boolean contains(String name, Object value) {
        Object opt = this.properties.get(name);
        if (opt != null) {
            if (opt instanceof Collection) {
                return ((Collection)opt).contains(value);
            }
            throw new RuntimeException("Expected collection for config entry: " + name);
        }
        return false;
    }

    public synchronized Config sub(String name) {
        Map submap = (Map)this.properties.get(name);
        if (submap == null) {
            submap = U.map();
            this.put(name, submap);
        } else if (!(submap instanceof Map)) {
            throw new RuntimeException("Invalid submap type: " + submap.getClass());
        }
        return new Config(submap);
    }

    public ConfigEntry entry(String ... name) {
        return new ConfigEntry(this, name);
    }

    public <T> T nested(String ... name) {
        Config cfg = this;
        for (int i = 0; i < name.length - 1; ++i) {
            if ((cfg = cfg.sub(name[i])) != null) continue;
            return null;
        }
        return (T)cfg.option(name[name.length - 1]);
    }

    public Map<String, Object> toMap() {
        return U.map(this.properties);
    }

    public void clear() {
        this.properties.clear();
    }

    public void put(String key, Object value) {
        this.properties.put(key, value);
    }

    public void remove(String name) {
        this.properties.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(Map<String, Object> newProperties) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.clear();
            this.properties.putAll(newProperties);
        }
    }

    public String toString() {
        return this.properties.toString();
    }

    public <T> T get(String key) {
        return (T)this.properties.get(key);
    }

    public <T> T getOrFail(String key, Class<T> clazz) {
        Object val = this.properties.get(key);
        U.must((val != null ? 1 : 0) != 0, (String)"Cannot find the configuration entry: %s", (Object)key);
        U.must((boolean)Cls.instanceOf((Object)val, (Class[])new Class[]{clazz}), (String)"The configuration entry '%s' must be of type: %s", (Object)key, (Object)clazz.getSimpleName());
        return (T)val;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }
}

