/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.Map;
import org.rapidoid.config.Config;
import org.rapidoid.config.ConfigHelp;
import org.rapidoid.data.YAML;
import org.rapidoid.io.Res;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class Conf {
    private static final Config ROOT = new Config();
    private static volatile Config USERS;
    private static String rootPath;
    private static String staticPath;
    private static String dynamicPath;
    private static String configPath;

    public static synchronized void args(String ... args) {
        Conf.init(args, null);
    }

    public static synchronized void init(String[] args, Object ... extraOptions) {
        ConfigHelp.processHelp(args);
        if (args != null) {
            for (String string : args) {
                Conf.processArg(string);
            }
        }
        if (extraOptions != null) {
            for (Object object : extraOptions) {
                if (!(object instanceof String)) continue;
                Conf.processArg((String)object);
            }
        }
    }

    private static void processArg(String arg) {
        Object value;
        String name;
        int pos = arg.indexOf(61);
        if (pos > 0) {
            name = arg.substring(0, pos);
            value = arg.substring(pos + 1);
        } else {
            name = arg;
            value = true;
        }
        ROOT.put(name, value);
        Conf.processArgIfSpecial(name, value);
    }

    private static void processArgIfSpecial(String name, Object value) {
        if (name.equals("path")) {
            Conf.setRootPath(value.toString());
        } else if (name.equals("static")) {
            Conf.setStaticPath(value.toString());
        } else if (name.equals("dynamic")) {
            Conf.setDynamicPath(value.toString());
        } else if (name.equals("config")) {
            Conf.setConfigPath(value.toString());
        }
    }

    public static void unconfigure(String name) {
        ROOT.remove(name);
    }

    public static Object option(String name) {
        return ROOT.option(name);
    }

    public static String option(String name, String defaultValue) {
        return ROOT.option(name, defaultValue);
    }

    public static int option(String name, int defaultValue) {
        return ROOT.option(name, defaultValue);
    }

    public static long option(String name, long defaultValue) {
        return ROOT.option(name, defaultValue);
    }

    public static double option(String name, double defaultValue) {
        return ROOT.option(name, defaultValue);
    }

    public static boolean has(String name, Object value) {
        return ROOT.has(name, value);
    }

    public static boolean is(String name) {
        return ROOT.is(name);
    }

    public static boolean contains(String name, Object value) {
        return ROOT.contains(name, value);
    }

    public static int port() {
        return Conf.option("port", 8888);
    }

    public static int cpus() {
        return Conf.option("cpus", Runtime.getRuntime().availableProcessors());
    }

    public static boolean micro() {
        return Conf.has("size", "micro");
    }

    public static boolean production() {
        return Conf.has("mode", "production");
    }

    public static boolean dev() {
        if (Conf.production()) {
            return false;
        }
        assert (Conf.configureDevMode());
        return Conf.has("mode", "dev") || !Conf.production();
    }

    private static boolean configureDevMode() {
        ROOT.put("mode", "dev");
        return true;
    }

    public static String secret() {
        return Conf.option("secret", null);
    }

    public static String system(String key) {
        String value = Conf.option(key, null);
        if (value == null) {
            value = System.getProperty(key);
        }
        if (value == null) {
            value = System.getenv(key);
        }
        return value;
    }

    public static String JAVA_HOME() {
        return Conf.system("JAVA_HOME");
    }

    public static String HOSTNAME() {
        return Conf.system("HOSTNAME");
    }

    public static String IP_ADDRESS() {
        return Conf.system("IP_ADDRESS");
    }

    public static void reset() {
        ROOT.clear();
    }

    public static Config root() {
        return ROOT;
    }

    public static void set(String key, Object value) {
        ROOT.put(key, value);
    }

    public static void set(String key, String subkey, Object value) {
        ROOT.sub(key).put(subkey, value);
    }

    public static <T> T nested(String ... name) {
        return ROOT.nested(name);
    }

    public static String rootPathDefault() {
        return "rapidoid";
    }

    public static String rootPath() {
        return rootPath;
    }

    public static String configPathDefault() {
        return Conf.rootPathDefault();
    }

    public static String configPath() {
        return configPath;
    }

    public static String staticPathDefault() {
        return Conf.rootPathDefault() + "/static";
    }

    public static String staticPath() {
        return staticPath;
    }

    public static String dynamicPathDefault() {
        return Conf.rootPathDefault() + "/dynamic";
    }

    public static String dynamicPath() {
        return dynamicPath;
    }

    private static String cleanPath(String path) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static Config sub(String name) {
        return Conf.root().sub(name);
    }

    public static synchronized void setRootPath(String rootPath) {
        Log.info((String)"Setting 'root' application path", (String)"path", (Object)rootPath);
        Conf.rootPath = Conf.cleanPath(rootPath);
        Conf.setStaticPath(Conf.rootPath + "/static");
        Conf.setDynamicPath(Conf.rootPath + "/dynamic");
        Conf.setConfigPath(Conf.rootPath);
        USERS = null;
    }

    public static void setStaticPath(String staticPath) {
        Log.info((String)"Setting 'static' application path", (String)"path", (Object)staticPath);
        Conf.staticPath = Conf.cleanPath(staticPath);
    }

    public static void setDynamicPath(String dynamicPath) {
        Log.info((String)"Setting 'dynamic' application path", (String)"path", (Object)dynamicPath);
        Conf.dynamicPath = Conf.cleanPath(dynamicPath);
    }

    public static void setConfigPath(String configPath) {
        Log.info((String)"Setting 'config' application path", (String)"path", (Object)configPath);
        Conf.configPath = Conf.cleanPath(configPath);
    }

    public static Config refreshing(String path, String filename) {
        Log.info((String)"Initializing auto-refreshing config", (String)"root", (Object)Conf.rootPath(), (String)"path", (Object)path, (String)"filename", (Object)filename);
        path = U.safe((String)path);
        String firstFile = U.path((String[])new String[]{Conf.rootPath(), path, filename});
        String defaultFile = U.path((String[])new String[]{Conf.rootPathDefault(), path, filename});
        Log.info((String)"Calculated resource path", (String)"primary", (Object)firstFile, (String)"default", (Object)defaultFile);
        final Res res = Res.from((String)filename, (boolean)true, (String[])new String[]{firstFile, defaultFile});
        Config config = (Config)res.attachment();
        if (config == null) {
            config = new Config();
            res.attach((Object)config);
        }
        final Config conf = config;
        Runnable reload = new Runnable(){

            @Override
            public void run() {
                byte[] bytes = res.getBytesOrNull();
                Map configData = bytes != null && bytes.length > 0 ? (Map)YAML.parse((byte[])bytes, Map.class) : U.map();
                conf.assign(configData);
            }
        };
        reload.run();
        res.onChange("config", reload);
        res.trackChanges();
        res.exists();
        return conf;
    }

    public static synchronized Config users() {
        if (USERS == null) {
            USERS = Conf.refreshing("", "users.yaml");
        }
        return USERS;
    }

    static {
        rootPath = Conf.rootPathDefault();
        staticPath = Conf.staticPathDefault();
        dynamicPath = Conf.dynamicPathDefault();
        configPath = Conf.configPathDefault();
    }
}

