/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.sheet;

import java.io.Serializable;
import java.util.Collection;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.primefaces.extensions.component.sheet.Sheet;
import org.primefaces.extensions.component.sheet.SheetInvalidUpdate;

public class SheetColumn
extends UIInput
implements ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.SheetColumn";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String MESSAGE_REQUIRED = "A valid value for this column is required.";
    private Object localValue;
    private Sheet sheet;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void setHeaderText(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.headerText), (Object)value);
    }

    public String getHeaderText() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.headerText), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public void setReadonly(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonly), (Object)value);
    }

    public Boolean isReadonly() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonly), (Object)Boolean.FALSE).toString());
    }

    public void setReadonlyCell(Boolean value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonlyCell), (Object)value);
    }

    public Boolean isReadonlyCell() {
        return Boolean.valueOf(this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonlyCell), (Object)Boolean.FALSE).toString());
    }

    public void setColWidth(Integer value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.colWidth), (Object)value);
    }

    public Integer getColWidth() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.colWidth), null);
        if (result == null) {
            return null;
        }
        return Integer.valueOf(result.toString());
    }

    public void setColType(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.colType), (Object)value);
    }

    public String getColType() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.colType), (Object)"text").toString();
    }

    public void setStyleClass(String value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)value);
    }

    public String getStyleClass() {
        Object result = this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public Object getFilterBy() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterBy), null);
    }

    public void setFilterBy(Object filterBy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterBy), filterBy);
    }

    public String getFilterValue() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.filterValue));
    }

    public void setFilterValue(String filterValue) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterValue), (Object)filterValue);
    }

    public Collection<SelectItem> getFilterOptions() {
        return (Collection)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterOptions), null);
    }

    public void setFilterOptions(Collection<SelectItem> filterOptions) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterOptions), filterOptions);
    }

    public Sheet getSheet() {
        UIComponent parent;
        if (this.sheet != null) {
            return this.sheet;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof Sheet); parent = parent.getParent()) {
        }
        return (Sheet)parent;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setValue(Object value) {
        this.localValue = value;
        this.setLocalValueSet(true);
    }

    public Object getValue() {
        return this.localValue;
    }

    public boolean isValid() {
        return this.getSheet().isValid();
    }

    public void setValid(boolean valid) {
        this.getSheet().setValid(valid);
    }

    public void processDecodes(FacesContext context) {
    }

    public void processUpdates(FacesContext context) {
    }

    public void resetValue() {
        this.setValue(null);
        this.setLocalValueSet(false);
    }

    public void processValidators(FacesContext context) {
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Validator[] validators = this.getValidators();
        Object value = this.getValue();
        if (!this.validateRequired(context, value)) {
            return;
        }
        if (validators == null) {
            return;
        }
        for (Validator validator : validators) {
            try {
                validator.validate(context, (UIComponent)this, value);
            }
            catch (ValidatorException ve) {
                FacesMessage message;
                this.setValid(false);
                String validatorMessageString = this.getValidatorMessage();
                if (null != validatorMessageString) {
                    message = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessageString, validatorMessageString);
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                } else {
                    Collection messages = ve.getFacesMessages();
                    if (null != messages) {
                        message = null;
                        String cid = this.getClientId(context);
                        for (FacesMessage m : messages) {
                            context.addMessage(cid, m);
                        }
                    } else {
                        message = ve.getFacesMessage();
                    }
                }
                if (message == null) continue;
                Sheet sheet = this.getSheet();
                if (sheet == null) {
                    return;
                }
                context.addMessage(this.getClientId(context), message);
                sheet.getInvalidUpdates().add(new SheetInvalidUpdate(sheet.getRowKeyValue(context), sheet.getColumns().indexOf((Object)this), this, value, message.getDetail()));
            }
        }
    }

    protected boolean validateRequired(FacesContext context, Object newValue) {
        if (this.isValid() && this.isRequired() && SheetColumn.isEmpty((Object)newValue)) {
            String requiredMessageStr = this.getRequiredMessage();
            FacesMessage message = null != requiredMessageStr ? new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessageStr, requiredMessageStr) : new FacesMessage(FacesMessage.SEVERITY_ERROR, MESSAGE_REQUIRED, MESSAGE_REQUIRED);
            context.addMessage(this.getClientId(context), message);
            Sheet sheet = this.getSheet();
            if (sheet != null) {
                sheet.getInvalidUpdates().add(new SheetInvalidUpdate(sheet.getRowKeyValue(context), sheet.getColumns().indexOf((Object)this), this, newValue, message.getDetail()));
            }
            this.setValid(false);
            return false;
        }
        return true;
    }

    static enum PropertyKeys {
        headerText,
        readonly,
        readonlyCell,
        colWidth,
        colType,
        styleClass,
        filterBy,
        filterOptions,
        filterValue;

    }
}

