/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.orgchart;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.primefaces.extensions.component.orgchart.OrgChart;
import org.primefaces.extensions.component.orgchart.OrgChartHelper;
import org.primefaces.extensions.component.orgchart.OrgChartNode;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.shaded.json.JSONArray;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.WidgetBuilder;

public class OrgChartRenderer
extends CoreRenderer {
    private static final String JSON_CHILDREN = "children";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OrgChart orgChart = (OrgChart)component;
        this.encodeMarkup(context, orgChart);
        this.encodeScript(context, orgChart);
    }

    public void decode(FacesContext context, UIComponent component) {
        OrgChart orgChart = (OrgChart)component;
        OrgChartRenderer.decodeNodeStructure(context, orgChart);
        this.decodeBehaviors(context, component);
    }

    private static void decodeNodeStructure(FacesContext context, OrgChart orgChart) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String hierarchyStr = (String)params.get(orgChart.getClientId() + "_hierarchy");
        if (null != hierarchyStr && !hierarchyStr.isEmpty()) {
            JSONObject hierarchy = new JSONObject(hierarchyStr);
            ValueExpression ve = orgChart.getValueExpression("value");
            OrgChartNode root = (OrgChartNode)ve.getValue(context.getELContext());
            List<OrgChartNode> orgChartNodes = OrgChartHelper.getAllNodesTraverseFromRoot(root);
            for (OrgChartNode o : orgChartNodes) {
                o.clearChildren();
            }
            Map<String, OrgChartNode> hashMap = OrgChartHelper.parseOrgChartNodesIntoHashMap(orgChartNodes);
            root = OrgChartRenderer.buildNodesFromJSON(hashMap, hierarchy, null);
            ve.setValue(context.getELContext(), (Object)root);
        }
    }

    public static OrgChartNode buildNodesFromJSON(Map<String, OrgChartNode> orgChartNodes, JSONObject hierarchy, OrgChartNode parentNode) {
        String id = (String)hierarchy.get("id");
        OrgChartNode node = orgChartNodes.get(id);
        if (parentNode == null) {
            parentNode = node;
        }
        if (hierarchy.has(JSON_CHILDREN)) {
            JSONArray array = (JSONArray)hierarchy.get(JSON_CHILDREN);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                OrgChartRenderer.buildNodesFromJSON(orgChartNodes, jsonObject, orgChartNodes.get(jsonObject.get("id")));
                parentNode.addChild(orgChartNodes.get(jsonObject.get("id")));
            }
        }
        return node;
    }

    private void encodeMarkup(FacesContext context, OrgChart orgChart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = orgChart.getClientId();
        String widgetVar = orgChart.resolveWidgetVar();
        String styleClass = this.getStyleClassBuilder(context).add("ui-orgchart ").add(orgChart.getStyleClass()).build();
        writer.startElement("div", (UIComponent)orgChart);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (orgChart.getStyle() != null) {
            writer.writeAttribute("style", (Object)orgChart.getStyle(), "style");
        }
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, OrgChart orgChart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        if (orgChart.getValue() == null) {
            throw new FacesException("The value attribute must be OrgChartNode");
        }
        if (!(orgChart.getValue() instanceof OrgChartNode)) {
            throw new FacesException("The value attribute must be OrgChartNode");
        }
        OrgChartNode orgChartNode = (OrgChartNode)orgChart.getValue();
        String data = OrgChartRenderer.toJSON(orgChartNode, orgChartNode.getChildren()).toString();
        wb.init("ExtOrgChart", (UIComponent)orgChart);
        wb.attr("nodeId", orgChart.getNodeId());
        wb.attr("nodeContent", orgChart.getNodeContent());
        wb.attr("direction", orgChart.getDirection());
        wb.attr("pan", orgChart.getPan());
        wb.attr("toggleSiblingsResp", orgChart.getToggleSiblingsResp());
        wb.attr("depth", (Number)orgChart.getDepth());
        wb.attr("exportButton", orgChart.getExportButton());
        wb.attr("exportFilename", orgChart.getExportFilename());
        wb.attr("exportFileextension", orgChart.getExportFileextension());
        wb.attr("parentNodeSymbol", orgChart.getParentNodeSymbol());
        wb.attr("draggable", orgChart.getDraggable());
        wb.attr("chartClass", orgChart.getChartClass());
        wb.attr("zoom", orgChart.getZoom());
        wb.attr("zoominLimit", orgChart.getZoominLimit());
        wb.attr("zoomoutLimit", orgChart.getZoomoutLimit());
        wb.attr("verticalDepth", (Number)orgChart.getVerticalDepth());
        wb.attr("nodeTitle", orgChart.getNodeTitle());
        wb.nativeAttr("extender", orgChart.getExtender());
        wb.attr("data", data);
        this.encodeClientBehaviors(context, orgChart);
        wb.finish();
    }

    public static JSONObject toJSON(OrgChartNode orgChartNode, List<OrgChartNode> children) {
        JSONObject json = new JSONObject();
        if (null != orgChartNode.getId() && !orgChartNode.getId().isEmpty()) {
            json.put("id", (Object)orgChartNode.getId());
        }
        json.put("name", (Object)orgChartNode.getName());
        json.put("title", (Object)orgChartNode.getTitle());
        if (null != orgChartNode.getClassName() && !orgChartNode.getClassName().isEmpty()) {
            json.put("className", (Object)orgChartNode.getClassName());
        }
        if (orgChartNode.getChildCount() > 0) {
            ArrayList<JSONObject> jsonChildren = new ArrayList<JSONObject>();
            for (int i = 0; i < orgChartNode.getChildCount(); ++i) {
                jsonChildren.add(OrgChartRenderer.toJSON(orgChartNode.getChildren().get(i), orgChartNode.getChildren().get(i).getChildren()));
            }
            json.put(JSON_CHILDREN, jsonChildren);
        }
        return json;
    }
}

