/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.primefaces.util.LocaleUtils;

public class MessageFactory {
    private static final String PF_EXTENSIONS_BUNDLE_BASENAME = "org.primefaces.extensions.Messages";
    private static final String DEFAULT_DETAIL_SUFFIX = "_detail";

    private MessageFactory() {
    }

    public static FacesMessage getMessage(String messageId, FacesMessage.Severity severity, Object ... params) {
        FacesMessage message = MessageFactory.getMessage(LocaleUtils.getCurrentLocale(), messageId, params);
        message.setSeverity(severity);
        return message;
    }

    public static FacesMessage getMessage(Locale locale, String messageId, Object ... params) {
        FacesMessage message = org.primefaces.util.MessageFactory.getFacesMessage((Locale)locale, (String)messageId, (Object[])params);
        if (message.getSummary() == null) {
            MessageFactory.populateMessageFromExtensions(message, locale, messageId, params);
        }
        return message;
    }

    public static Object getLabel(FacesContext facesContext, UIComponent component) {
        return org.primefaces.util.MessageFactory.getLabel((FacesContext)facesContext, (UIComponent)component);
    }

    private static void populateMessageFromExtensions(FacesMessage message, Locale locale, String messageId, Object[] params) {
        ResourceBundle extensionsBundle = MessageFactory.getExtensionsBundle(locale);
        message.setSummary(org.primefaces.util.MessageFactory.getFormattedText((Locale)locale, (String)extensionsBundle.getString(messageId), (Object[])params));
        try {
            message.setDetail(org.primefaces.util.MessageFactory.getFormattedText((Locale)locale, (String)extensionsBundle.getString(messageId + DEFAULT_DETAIL_SUFFIX), (Object[])params));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private static ResourceBundle getExtensionsBundle(Locale locale) {
        return ResourceBundle.getBundle(PF_EXTENSIONS_BUNDLE_BASENAME, locale, Thread.currentThread().getContextClassLoader());
    }
}

