/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.behavior.javascript;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ClientBehaviorRenderer;
import java.util.Collection;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.extensions.behavior.javascript.JavascriptBehavior;

public class JavascriptBehaviorRenderer
extends ClientBehaviorRenderer {
    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        ClientBehaviorRenderingMode renderingMode;
        JavascriptBehavior javascriptBehavior = (JavascriptBehavior)behavior;
        if (javascriptBehavior.isDisabled()) {
            return null;
        }
        FacesContext context = behaviorContext.getFacesContext();
        UIComponent component = behaviorContext.getComponent();
        String source = behaviorContext.getSourceId();
        if (source == null) {
            source = component.getClientId(context);
        }
        StringBuilder script = new StringBuilder();
        script.append("PrimeFacesExt.behavior.Javascript({");
        script.append("source:'").append(source).append("'");
        script.append(",event:'").append(behaviorContext.getEventName()).append("'");
        script.append(",execute:function(source,event,params,ext){");
        script.append(javascriptBehavior.getExecute()).append(";}");
        boolean paramWritten = false;
        for (int i = 0; i < component.getChildCount(); ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            if (paramWritten) {
                script.append(",");
            } else {
                paramWritten = true;
                script.append(",params:{");
            }
            script.append("'");
            script.append(parameter.getName()).append("':'").append(parameter.getValue());
            script.append("'");
        }
        if (paramWritten) {
            script.append("}");
        }
        if (ClientBehaviorRenderingMode.UNOBSTRUSIVE.equals((Object)(renderingMode = JavascriptBehaviorRenderer.getClientBehaviorRenderingMode(behaviorContext)))) {
            script.append("},ext);");
        } else {
            script.append("});");
        }
        return script.toString();
    }

    protected static ClientBehaviorRenderingMode getClientBehaviorRenderingMode(ClientBehaviorContext behaviorContext) {
        Collection behaviorParameters = behaviorContext.getParameters();
        if (behaviorParameters == null || behaviorParameters.isEmpty()) {
            return null;
        }
        for (ClientBehaviorContext.Parameter behaviorParameter : behaviorParameters) {
            if (!(behaviorParameter.getValue() instanceof ClientBehaviorRenderingMode)) continue;
            return (ClientBehaviorRenderingMode)behaviorParameter.getValue();
        }
        return null;
    }
}

