/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.configuration.support;

import org.powermock.configuration.Configuration;
import org.powermock.configuration.ConfigurationFactory;
import org.powermock.configuration.support.ConfigurationReaderBuilder;

public class ConfigurationFactoryImpl
implements ConfigurationFactory {
    private static final String USER_CONFIGURATION = "org/powermock/extensions/configuration.properties";
    private static final String DEFAULT_CONFIGURATION = "org/powermock/default.properties";

    @Override
    public <T extends Configuration<T>> T create(Class<T> configurationType) {
        T configuration = this.readUserConfiguration(configurationType);
        T defaultConfiguration = this.readDefault(configurationType);
        return defaultConfiguration.merge(configuration);
    }

    private <T extends Configuration> T readDefault(Class<T> configurationType) {
        T configuration = ConfigurationReaderBuilder.newBuilder().forConfigurationFile(DEFAULT_CONFIGURATION).build().read(configurationType);
        if (configuration == null) {
            throw new RuntimeException("Default configuration is null. It should never happen. If you see this exception, it means that something wrong with build. Please report to PowerMock issues tracker.");
        }
        return configuration;
    }

    private <T extends Configuration> T readUserConfiguration(Class<T> configurationType) {
        return ConfigurationReaderBuilder.newBuilder().forConfigurationFile(USER_CONFIGURATION).build().read(configurationType);
    }
}

