/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.openid.credentials.extractor;

import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.message.ParameterList;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.openid.client.YahooOpenIdClient;
import org.pac4j.openid.credentials.OpenIdCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YahooCredentialsExtractor
implements CredentialsExtractor<OpenIdCredentials> {
    private static final Logger logger = LoggerFactory.getLogger(YahooCredentialsExtractor.class);
    private static final String OPENID_MODE = "openid.mode";
    private static final String CANCEL_MODE = "cancel";
    private YahooOpenIdClient client;

    public YahooCredentialsExtractor(YahooOpenIdClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.client = client;
    }

    public OpenIdCredentials extract(WebContext context) {
        String mode = context.getRequestParameter(OPENID_MODE);
        if (CommonHelper.areEquals((String)mode, (String)CANCEL_MODE)) {
            logger.debug("authentication cancelled");
            return null;
        }
        ParameterList parameterList = new ParameterList(context.getRequestParameters());
        DiscoveryInformation discoveryInformation = (DiscoveryInformation)context.getSessionStore().get(context, this.client.getDiscoveryInformationSessionAttributeName());
        OpenIdCredentials credentials = new OpenIdCredentials(discoveryInformation, parameterList);
        logger.debug("credentials: {}", (Object)credentials);
        return credentials;
    }
}

