/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.context;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;

public class JEEContext
implements WebContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private String body;

    public JEEContext(HttpServletRequest request, HttpServletResponse response) {
        CommonHelper.assertNotNull("request", request);
        CommonHelper.assertNotNull("response", response);
        this.request = request;
        this.response = response;
    }

    @Override
    public Optional<String> getRequestParameter(String name) {
        return Optional.ofNullable(this.request.getParameter(name));
    }

    @Override
    public Optional getRequestAttribute(String name) {
        return Optional.ofNullable(this.request.getAttribute(name));
    }

    @Override
    public void setRequestAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public Map<String, String[]> getRequestParameters() {
        return this.request.getParameterMap();
    }

    @Override
    public Optional<String> getRequestHeader(String name) {
        Enumeration names = this.request.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                if (headerName == null || !headerName.equalsIgnoreCase(name)) continue;
                return Optional.ofNullable(this.request.getHeader(headerName));
            }
        }
        return Optional.empty();
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public HttpServletRequest getNativeRequest() {
        return this.request;
    }

    public HttpServletResponse getNativeResponse() {
        return this.response;
    }

    @Override
    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    @Override
    public Optional<String> getResponseHeader(String name) {
        return Optional.ofNullable(this.response.getHeader(name));
    }

    @Override
    public void setResponseContentType(String content) {
        this.response.setContentType(content);
    }

    @Override
    public String getServerName() {
        return this.request.getServerName();
    }

    @Override
    public int getServerPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }

    @Override
    public String getRequestURL() {
        String url = this.request.getRequestURL().toString();
        int idx = url.indexOf(63);
        if (idx != -1) {
            return url.substring(0, idx);
        }
        return url;
    }

    @Override
    public String getFullRequestURL() {
        StringBuffer requestURL = this.request.getRequestURL();
        String queryString = this.request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    @Override
    public Collection<Cookie> getRequestCookies() {
        LinkedHashSet<Cookie> pac4jCookies = new LinkedHashSet<Cookie>();
        javax.servlet.http.Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (javax.servlet.http.Cookie c : cookies) {
                Cookie cookie = new Cookie(c.getName(), c.getValue());
                cookie.setDomain(c.getDomain());
                cookie.setHttpOnly(c.isHttpOnly());
                cookie.setMaxAge(c.getMaxAge());
                cookie.setPath(c.getPath());
                cookie.setSecure(c.getSecure());
                pac4jCookies.add(cookie);
            }
        }
        return pac4jCookies;
    }

    @Override
    public void addResponseCookie(Cookie cookie) {
        this.response.addHeader("Set-Cookie", WebContextHelper.createCookieHeader(cookie));
    }

    @Override
    public String getPath() {
        String context;
        String fullPath = this.request.getRequestURI();
        if (fullPath == null) {
            return "";
        }
        if (fullPath.startsWith("//")) {
            fullPath = fullPath.substring(1);
        }
        if ((context = this.request.getContextPath()) != null) {
            return fullPath.substring(context.length());
        }
        return fullPath;
    }

    @Override
    public String getRequestContent() {
        if (this.body == null) {
            try {
                this.body = this.request.getReader().lines().reduce("", String::concat);
            }
            catch (IOException e) {
                throw new TechnicalException(e);
            }
        }
        return this.body;
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol();
    }
}

