/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Checksum {
    private static final String HEXES = "0123456789abcdef";
    private static final Logger LOGGER = LoggerFactory.getLogger(Checksum.class);
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final String SHA256 = "SHA-256";
    private static final Map<String, Map<File, byte[]>> CHECKSUM_CACHES = new HashMap<String, Map<File, byte[]>>(3);

    private Checksum() {
    }

    public static byte[] getChecksum(String algorithm, File file) throws NoSuchAlgorithmException, IOException {
        Map<File, byte[]> checksumCache = CHECKSUM_CACHES.get(algorithm.toUpperCase());
        if (checksumCache == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        byte[] checksum = checksumCache.get(file);
        if (checksum == null) {
            checksum = new DigestUtils(algorithm).digest(file);
            checksumCache.put(file, checksum);
        }
        return checksum;
    }

    public static String getMD5Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum(MD5, file);
        return Checksum.getHex(b);
    }

    public static String getSHA1Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum(SHA1, file);
        return Checksum.getHex(b);
    }

    public static String getSHA256Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum(SHA256, file);
        return Checksum.getHex(b);
    }

    public static String getChecksum(String algorithm, byte[] bytes) {
        MessageDigest digest = Checksum.getMessageDigest(algorithm);
        byte[] b = digest.digest(bytes);
        return Checksum.getHex(b);
    }

    public static String getMD5Checksum(String text) {
        byte[] data = Checksum.stringToBytes(text);
        return Checksum.getChecksum(MD5, data);
    }

    public static String getSHA1Checksum(String text) {
        byte[] data = Checksum.stringToBytes(text);
        return Checksum.getChecksum(SHA1, data);
    }

    public static String getSHA256Checksum(String text) {
        byte[] data = Checksum.stringToBytes(text);
        return Checksum.getChecksum(SHA256, data);
    }

    private static byte[] stringToBytes(String text) {
        byte[] data;
        try {
            data = text.getBytes(Charset.forName(StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedCharsetException ex) {
            data = text.getBytes(Charset.defaultCharset());
        }
        return data;
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String msg = String.format("Failed to obtain the %s message digest.", algorithm);
            throw new IllegalStateException(msg, e);
        }
    }

    static {
        CHECKSUM_CACHES.put(MD5, new ConcurrentHashMap());
        CHECKSUM_CACHES.put(SHA256, new ConcurrentHashMap());
        CHECKSUM_CACHES.put(SHA1, new ConcurrentHashMap());
    }
}

