/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.gradle.tasks;

import com.google.common.base.Strings;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.owasp.dependencycheck.gradle.extension.DependencyCheckExtension;
import org.owasp.dependencycheck.gradle.service.SlackNotificationSenderService;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.Settings;

public abstract class ConfiguredTask
extends DefaultTask
implements GroovyObject {
    @org.gradle.api.tasks.Internal
    private DependencyCheckExtension config;
    @org.gradle.api.tasks.Internal
    private Settings settings;
    @org.gradle.api.tasks.Internal
    private String PROPERTIES_FILE;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ConfiguredTask() {
        MetaClass metaClass;
        String string;
        DependencyCheckExtension dependencyCheckExtension;
        this.config = dependencyCheckExtension = (DependencyCheckExtension)ScriptBytecodeAdapter.castToType((Object)this.getProject().getExtensions().findByName("dependencyCheck"), DependencyCheckExtension.class);
        this.PROPERTIES_FILE = string = "task.properties";
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeSettings() {
        boolean bl;
        Settings settings;
        this.settings = settings = new Settings();
        InputStream taskProperties = null;
        try {
            try {
                InputStream inputStream;
                taskProperties = inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.PROPERTIES_FILE);
                this.settings.mergeProperties(taskProperties);
            }
            catch (IOException ex) {
                this.getLogger().warn("Unable to load the dependency-check gradle task.properties file.");
                this.getLogger().debug("", (Throwable)ex);
            }
            bl = taskProperties != null;
        }
        catch (Throwable throwable) {
            if (!(taskProperties != null)) throw throwable;
            try {
                taskProperties.close();
                throw throwable;
            }
            catch (IOException ex) {
                this.getLogger().debug("", (Throwable)ex);
                throw throwable;
            }
        }
        if (bl) {
            try {
                taskProperties.close();
            }
            catch (IOException ex) {
                this.getLogger().debug("", (Throwable)ex);
            }
        }
        this.settings.setBooleanIfNotNull(Settings.KEYS.AUTO_UPDATE, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAutoUpdate().getOrNull(), Boolean.class));
        String[] suppressionLists = this.determineSuppressions((Collection)ScriptBytecodeAdapter.castToType((Object)this.config.getSuppressionFiles().getOrElse((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0])), Collection.class), ShortTypeHandling.castToString((Object)this.config.getSuppressionFile().getOrNull()));
        this.settings.setArrayIfNotEmpty(Settings.KEYS.SUPPRESSION_FILE, suppressionLists);
        this.settings.setStringIfNotEmpty(Settings.KEYS.SUPPRESSION_FILE_USER, ShortTypeHandling.castToString((Object)this.config.getSuppressionFileUser().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.SUPPRESSION_FILE_PASSWORD, ShortTypeHandling.castToString((Object)this.config.getSuppressionFilePassword().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.SUPPRESSION_FILE_BEARER_TOKEN, ShortTypeHandling.castToString((Object)this.config.getSuppressionFileBearerToken().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.HINTS_FILE, ShortTypeHandling.castToString((Object)this.config.getHintsFile().getOrNull()));
        this.configureProxy(this.settings);
        this.configureSlack(this.settings);
        this.settings.setStringIfNotNull(Settings.KEYS.DATA_DIRECTORY, ShortTypeHandling.castToString((Object)this.config.getData().getDirectory().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_DRIVER_NAME, ShortTypeHandling.castToString((Object)this.config.getData().getDriver().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_DRIVER_PATH, ShortTypeHandling.castToString((Object)this.config.getData().getDriverPath().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_CONNECTION_STRING, ShortTypeHandling.castToString((Object)this.config.getData().getConnectionString().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_USER, ShortTypeHandling.castToString((Object)this.config.getData().getUsername().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.DB_PASSWORD, ShortTypeHandling.castToString((Object)this.config.getData().getPassword().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_KEY, ShortTypeHandling.castToString((Object)this.config.getNvd().getApiKey().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_ENDPOINT, ShortTypeHandling.castToString((Object)this.config.getNvd().getEndpoint().getOrNull()));
        this.settings.setIntIfNotNull(Settings.KEYS.NVD_API_DELAY, (Integer)ScriptBytecodeAdapter.castToType((Object)this.config.getNvd().getDelay().getOrNull(), Integer.class));
        this.settings.setIntIfNotNull(Settings.KEYS.NVD_API_RESULTS_PER_PAGE, (Integer)ScriptBytecodeAdapter.castToType((Object)this.config.getNvd().getResultsPerPage().getOrNull(), Integer.class));
        this.settings.setIntIfNotNull(Settings.KEYS.NVD_API_MAX_RETRY_COUNT, (Integer)ScriptBytecodeAdapter.castToType((Object)this.config.getNvd().getMaxRetryCount().getOrNull(), Integer.class));
        this.settings.setIntIfNotNull(Settings.KEYS.NVD_API_VALID_FOR_HOURS, (Integer)ScriptBytecodeAdapter.castToType((Object)this.config.getNvd().getValidForHours().getOrNull(), Integer.class));
        this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_DATAFEED_URL, ShortTypeHandling.castToString((Object)this.config.getNvd().getDatafeedUrl().getOrNull()));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.config.getNvd().getDatafeedUser().getOrNull()) && DefaultTypeTransformation.booleanUnbox((Object)this.config.getNvd().getDatafeedPassword().getOrNull())) {
            this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_DATAFEED_USER, ShortTypeHandling.castToString((Object)this.config.getNvd().getDatafeedUser().getOrNull()));
            this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_DATAFEED_PASSWORD, ShortTypeHandling.castToString((Object)this.config.getNvd().getDatafeedPassword().getOrNull()));
        }
        this.settings.setStringIfNotEmpty(Settings.KEYS.NVD_API_DATAFEED_BEARER_TOKEN, ShortTypeHandling.castToString((Object)this.config.getNvd().getDatafeedBearerToken().getOrNull()));
        this.settings.setIntIfNotNull(Settings.KEYS.NVD_API_DATAFEED_START_YEAR, (Integer)ScriptBytecodeAdapter.castToType((Object)this.config.getNvd().getDatafeedStartYear().getOrNull(), Integer.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.DOWNLOADER_QUICK_QUERY_TIMESTAMP, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getQuickQueryTimestamp().getOrNull(), Boolean.class));
        this.settings.setFloat(Settings.KEYS.JUNIT_FAIL_ON_CVSS, DefaultTypeTransformation.floatUnbox((Object)this.config.getJunitFailOnCVSS().get()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.FAIL_ON_UNUSED_SUPPRESSION_RULE, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getFailBuildOnUnusedSuppressionRule().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.HOSTED_SUPPRESSIONS_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getHostedSuppressions().getEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.HOSTED_SUPPRESSIONS_FORCEUPDATE, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getHostedSuppressions().getForceupdate().getOrNull(), Boolean.class));
        this.settings.setStringIfNotNull(Settings.KEYS.HOSTED_SUPPRESSIONS_URL, ShortTypeHandling.castToString((Object)this.config.getHostedSuppressions().getUrl().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.HOSTED_SUPPRESSIONS_USER, ShortTypeHandling.castToString((Object)this.config.getHostedSuppressions().getUser().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.HOSTED_SUPPRESSIONS_PASSWORD, ShortTypeHandling.castToString((Object)this.config.getHostedSuppressions().getPassword().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.HOSTED_SUPPRESSIONS_BEARER_TOKEN, ShortTypeHandling.castToString((Object)this.config.getHostedSuppressions().getBearerToken().getOrNull()));
        if (this.config.getHostedSuppressions().getValidForHours().getOrNull() != null) {
            if (!ScriptBytecodeAdapter.compareGreaterThanEqual((Object)this.config.getHostedSuppressions().getValidForHours().getOrNull(), (Object)0)) throw (Throwable)new InvalidUserDataException("Invalid setting: `validForHours` must be 0 or greater");
            this.settings.setInt(Settings.KEYS.HOSTED_SUPPRESSIONS_VALID_FOR_HOURS, DefaultTypeTransformation.intUnbox((Object)this.config.getHostedSuppressions().getValidForHours().getOrNull()));
        }
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_JAR_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getJarEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NUSPEC_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNuspecEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OSSINDEX_ENABLED, this.select((Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getOssIndex().getEnabled().getOrNull(), Boolean.class), (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getOssIndexEnabled().getOrNull(), Boolean.class)));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OSSINDEX_WARN_ONLY_ON_REMOTE_ERRORS, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getOssIndex().getWarnOnlyOnRemoteErrors().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OSSINDEX_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getOssIndex().getEnabled().getOrNull(), Boolean.class));
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_OSSINDEX_USER, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getOssIndex().getUsername().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_OSSINDEX_PASSWORD, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getOssIndex().getPassword().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_OSSINDEX_URL, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getOssIndex().getUrl().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_CENTRAL_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getCentralEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NEXUS_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNexus().getEnabled().getOrNull(), Boolean.class));
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_NEXUS_URL, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getNexus().getUrl().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NEXUS_USES_PROXY, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNexus().getUsesProxy().getOrNull(), Boolean.class));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_NEXUS_USER, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getNexus().getUsername().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_NEXUS_PASSWORD, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getNexus().getPassword().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_EXPERIMENTAL_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getExperimentalEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ARCHIVE_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getArchiveEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_KNOWN_EXPLOITED_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getKev().getEnabled().getOrNull(), Boolean.class));
        this.settings.setStringIfNotNull(Settings.KEYS.KEV_URL, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getKev().getUrl().getOrNull()));
        this.settings.setIntIfNotNull(Settings.KEYS.KEV_CHECK_VALID_FOR_HOURS, (Integer)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getKev().getValidForHours().getOrNull(), Integer.class));
        this.settings.setStringIfNotNull(Settings.KEYS.KEV_USER, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getKev().getUser().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.KEV_PASSWORD, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getKev().getPassword().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.KEV_BEARER_TOKEN, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getKev().getBearerToken().getOrNull()));
        this.settings.setStringIfNotEmpty(Settings.KEYS.ADDITIONAL_ZIP_EXTENSIONS, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getZipExtensions().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ASSEMBLY_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getAssemblyEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_MSBUILD_PROJECT_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getMsbuildEnabled().getOrNull(), Boolean.class));
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_ASSEMBLY_DOTNET_PATH, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getPathToDotnet().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_GOLANG_DEP_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getGolangDepEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_GOLANG_MOD_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getGolangModEnabled().getOrNull(), Boolean.class));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_GOLANG_PATH, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getPathToGo().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_COCOAPODS_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getCocoapodsEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_SWIFT_PACKAGE_MANAGER_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getSwiftEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_DART_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getDartEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_SWIFT_PACKAGE_RESOLVED_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getSwiftPackageResolvedEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_BUNDLE_AUDIT_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getBundleAuditEnabled().getOrNull(), Boolean.class));
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_BUNDLE_AUDIT_PATH, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getPathToBundleAudit().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_PYTHON_DISTRIBUTION_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getPyDistributionEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_PYTHON_PACKAGE_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getPyPackageEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_RUBY_GEMSPEC_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getRubygemsEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OPENSSL_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getOpensslEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_CMAKE_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getCmakeEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_AUTOCONF_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getAutoconfEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_COMPOSER_LOCK_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getComposerEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_COMPOSER_LOCK_SKIP_DEV, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getComposerSkipDev().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_CPANFILE_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getCpanEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NUGETCONF_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNugetconfEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_PACKAGE_ENABLED, this.select((Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNodePackage().getEnabled().getOrNull(), Boolean.class), (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNodeEnabled().getOrNull(), Boolean.class)));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_PACKAGE_SKIPDEV, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNodePackage().getSkipDevDependencies().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_AUDIT_ENABLED, this.select((Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNodeAudit().getEnabled().getOrNull(), Boolean.class), (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNodeAuditEnabled().getOrNull(), Boolean.class)));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_AUDIT_USE_CACHE, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNodeAudit().getUseCache().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_AUDIT_SKIPDEV, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNodeAudit().getSkipDevDependencies().getOrNull(), Boolean.class));
        this.settings.setStringIfNotEmpty(Settings.KEYS.ANALYZER_NODE_AUDIT_URL, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getNodeAudit().getUrl().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_YARN_AUDIT_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNodeAudit().getYarnEnabled().getOrNull(), Boolean.class));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_YARN_PATH, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getNodeAudit().getYarnPath().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_PNPM_AUDIT_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getNodeAudit().getPnpmEnabled().getOrNull(), Boolean.class));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_PNPM_PATH, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getNodeAudit().getPnpmPath().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getRetirejs().getEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_FORCEUPDATE, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getRetirejs().getForceupdate().getOrNull(), Boolean.class));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_REPO_JS_URL, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getRetirejs().getRetireJsUrl().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_REPO_JS_USER, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getRetirejs().getUser().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_REPO_JS_PASSWORD, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getRetirejs().getPassword().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_REPO_JS_BEARER_TOKEN, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getRetirejs().getBearerToken().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_RETIREJS_FILTER_NON_VULNERABLE, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getRetirejs().getFilterNonVulnerable().getOrNull(), Boolean.class));
        this.settings.setArrayIfNotEmpty(Settings.KEYS.ANALYZER_RETIREJS_FILTERS, (List)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getRetirejs().getFilters().getOrElse((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getArtifactory().getEnabled().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_PARALLEL_ANALYSIS, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getArtifactory().getParallelAnalysis().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_USES_PROXY, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getAnalyzers().getArtifactory().getUsesProxy().getOrNull(), Boolean.class));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_URL, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getArtifactory().getUrl().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_API_TOKEN, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getArtifactory().getApiToken().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_API_USERNAME, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getArtifactory().getUsername().getOrNull()));
        this.settings.setStringIfNotNull(Settings.KEYS.ANALYZER_ARTIFACTORY_BEARER_TOKEN, ShortTypeHandling.castToString((Object)this.config.getAnalyzers().getArtifactory().getBearerToken().getOrNull()));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_NODE_AUDIT_USE_CACHE, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getCache().getNodeAudit().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_CENTRAL_USE_CACHE, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getCache().getCentral().getOrNull(), Boolean.class));
        this.settings.setBooleanIfNotNull(Settings.KEYS.ANALYZER_OSSINDEX_USE_CACHE, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getCache().getOssIndex().getOrNull(), Boolean.class));
        Downloader.getInstance().configure(this.settings);
    }

    private void configureSlack(Settings settings) {
        settings.setBooleanIfNotNull(SlackNotificationSenderService.SLACK__WEBHOOK__ENABLED, (Boolean)ScriptBytecodeAdapter.castToType((Object)this.config.getSlack().getEnabled().getOrNull(), Boolean.class));
        settings.setStringIfNotEmpty(SlackNotificationSenderService.SLACK__WEBHOOK__URL, ShortTypeHandling.castToString((Object)this.config.getSlack().getWebhookUrl().getOrNull()));
    }

    private void configureProxy(Settings settings) {
        String proxyHost = System.getProperty("https.proxyHost", System.getProperty("http.proxyHost"));
        if (!Strings.isNullOrEmpty((String)proxyHost)) {
            String proxyPort = System.getProperty("https.proxyPort", System.getProperty("http.proxyPort"));
            String nonProxyHosts = System.getProperty("https.nonProxyHosts", System.getProperty("http.nonProxyHosts"));
            String proxyUser = System.getProperty("https.proxyUser", System.getProperty("http.proxyUser"));
            String proxyPassword = System.getProperty("https.proxyPassword", System.getProperty("http.proxyPassword"));
            this.config.getProxy().getServer().set((Object)proxyHost);
            try {
                this.config.getProxy().getPort().set((Object)Integer.parseInt(proxyPort));
            }
            catch (NumberFormatException nfe) {
                this.getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{proxyPort}, new String[]{"Unable to convert the configured `http.proxyPort` to a number: ", ""})));
            }
            if (!Strings.isNullOrEmpty((String)proxyUser)) {
                this.config.getProxy().getUsername().set((Object)proxyUser);
            }
            if (!Strings.isNullOrEmpty((String)proxyPassword)) {
                this.config.getProxy().getPassword().set((Object)proxyPassword);
            }
            if (!Strings.isNullOrEmpty((String)nonProxyHosts)) {
                this.config.getProxy().getNonProxyHosts().set((Iterable)StringGroovyMethods.tokenize((CharSequence)nonProxyHosts, (CharSequence)"|"));
            }
        }
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_SERVER, ShortTypeHandling.castToString((Object)this.config.getProxy().getServer().getOrNull()));
        Object object = this.config.getProxy().getPort().getOrNull();
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_PORT, object != null ? ((Integer)object).toString() : null);
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_USERNAME, ShortTypeHandling.castToString((Object)this.config.getProxy().getUsername().getOrNull()));
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_PASSWORD, ShortTypeHandling.castToString((Object)this.config.getProxy().getPassword().getOrNull()));
        List nonProxyHostsList = (List)ScriptBytecodeAdapter.castToType((Object)this.config.getProxy().getNonProxyHosts().getOrElse((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
        settings.setStringIfNotEmpty(Settings.KEYS.PROXY_NON_PROXY_HOSTS, ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox((Object)nonProxyHostsList) ? DefaultGroovyMethods.join((Iterable)nonProxyHostsList, (String)"|") : null));
    }

    private String[] determineSuppressions(Collection<String> suppressionFiles, String suppressionFile) {
        List files = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (suppressionFiles != null) {
            Collection<String> collection = suppressionFiles;
            Iterator<String> iterator = collection != null ? collection.iterator() : null;
            String sf = null;
            Iterator<String> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    sf = ShortTypeHandling.castToString((Object)iterator2.next());
                    files.add(sf.toString());
                }
            }
        }
        if (suppressionFile != null) {
            files.add(suppressionFile);
        }
        return (String[])ScriptBytecodeAdapter.castToType((Object)files.toArray((Object[])ScriptBytecodeAdapter.castToType((Object)new String[0], Object[].class)), String[].class);
    }

    private Boolean select(Boolean current, Boolean deprecated) {
        return current != null ? current : deprecated;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ConfiguredTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public DependencyCheckExtension getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(DependencyCheckExtension dependencyCheckExtension) {
        this.config = dependencyCheckExtension;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public String getPROPERTIES_FILE() {
        return this.PROPERTIES_FILE;
    }

    @Generated
    public void setPROPERTIES_FILE(String string) {
        this.PROPERTIES_FILE = string;
    }
}

