/*
 * This file is part of dependency-check-gradle.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2019 Jeremy Long. All Rights Reserved.
 */
package org.owasp.dependencycheck.gradle.extension

import org.gradle.api.model.ObjectFactory
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.Optional

import javax.inject.Inject

/**
 * The configuration for Slack notifications.
 */
@groovy.transform.CompileStatic
class SlackExtension {

    private final Property<Boolean> enabled
    private final Property<String> webhookUrl

    @Inject
    SlackExtension(ObjectFactory objects) {
        this.enabled = objects.property(Boolean)
        this.webhookUrl = objects.property(String)
    }

    @Input
    @Optional
    Property<Boolean> getEnabled() {
        return enabled
    }

    void setEnabled(Boolean value) {
        enabled.set(value)
    }

    @Input
    @Optional
    Property<String> getWebhookUrl() {
        return webhookUrl
    }

    void setWebhookUrl(String value) {
        webhookUrl.set(value)
    }
}
