/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.assembly;

import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.xml.assembly.AssemblyData;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
public class GrokHandler
extends DefaultHandler {
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String COMPANY_NAME = "companyName";
    private static final String PRODUCT_NAME = "productName";
    private static final String PRODUCT_VERSION = "productVersion";
    private static final String COMMENTS = "comments";
    private static final String FILE_DESCRIPTION = "fileDescription";
    private static final String FILE_NAME = "fileName";
    private static final String FILE_VERSION = "fileVersion";
    private static final String INTERNAL_NAME = "internalName";
    private static final String ORIGINAL_FILE_NAME = "originalFilename";
    private static final String FULLNAME = "fullName";
    private static final String NAMESPACE = "namespace";
    private final AssemblyData data = new AssemblyData();
    private StringBuilder currentText;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentText = new StringBuilder();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (null != qName) {
            switch (qName) {
                case "companyName": {
                    this.data.setCompanyName(this.currentText.toString());
                    break;
                }
                case "productName": {
                    this.data.setProductName(this.currentText.toString());
                    break;
                }
                case "productVersion": {
                    this.data.setProductVersion(this.currentText.toString());
                    break;
                }
                case "comments": {
                    this.data.setComments(this.currentText.toString());
                    break;
                }
                case "fileDescription": {
                    this.data.setFileDescription(this.currentText.toString());
                    break;
                }
                case "fileName": {
                    this.data.setFileName(this.currentText.toString());
                    break;
                }
                case "fileVersion": {
                    this.data.setFileVersion(this.currentText.toString());
                    break;
                }
                case "internalName": {
                    this.data.setInternalName(this.currentText.toString());
                    break;
                }
                case "originalFilename": {
                    this.data.setOriginalFilename(this.currentText.toString());
                    break;
                }
                case "fullName": {
                    this.data.setFullName(this.currentText.toString());
                    break;
                }
                case "namespace": {
                    this.data.addNamespace(this.currentText.toString());
                    break;
                }
                case "error": {
                    this.data.setError(this.currentText.toString());
                    break;
                }
                case "warning": {
                    this.data.setWarning(this.currentText.toString());
                    break;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText.append(ch, start, length);
    }

    AssemblyData getAssemblyData() {
        return this.data;
    }
}

