/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import org.owasp.dependencycheck.utils.WriteLock;
import org.owasp.dependencycheck.utils.WriteLockShutdownHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteLockCleanupHook
extends WriteLockShutdownHook {
    private WriteLock lock;
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteLockCleanupHook.class);

    @Override
    public void add(WriteLock lock) {
        this.lock = lock;
        Runtime.getRuntime().addShutdownHook(this);
    }

    @Override
    public void remove() {
        try {
            Runtime.getRuntime().removeShutdownHook(this);
        }
        catch (IllegalStateException ex) {
            LOGGER.trace("ignore as we are likely shutting down", (Throwable)ex);
        }
    }

    @Override
    public void run() {
        if (this.lock != null) {
            this.lock.close();
            this.lock = null;
        }
    }
}

