/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nuget;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.data.nuget.MSBuildProjectParseException;
import org.owasp.dependencycheck.data.nuget.MSBuildProjectParser;
import org.owasp.dependencycheck.data.nuget.NugetPackageReference;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathMSBuildProjectParser
implements MSBuildProjectParser {
    @Override
    public List<NugetPackageReference> parse(InputStream stream) throws MSBuildProjectParseException {
        try {
            DocumentBuilder db = XmlUtils.buildSecureDocumentBuilder();
            Document d = db.parse(stream);
            XPath xpath = XPathFactory.newInstance().newXPath();
            ArrayList<NugetPackageReference> packages = new ArrayList<NugetPackageReference>();
            NodeList nodeList = (NodeList)xpath.evaluate("//PackageReference", d, XPathConstants.NODESET);
            if (nodeList == null) {
                throw new MSBuildProjectParseException("Unable to parse MSBuild project file");
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap attrs = node.getAttributes();
                String include = attrs.getNamedItem("Include").getNodeValue();
                String version = null;
                if (attrs.getNamedItem("Version") != null) {
                    version = attrs.getNamedItem("Version").getNodeValue();
                } else if (xpath.evaluate("Version", node, XPathConstants.NODE) instanceof Node) {
                    version = ((Node)xpath.evaluate("Version", node, XPathConstants.NODE)).getTextContent();
                }
                if (include == null || version == null) continue;
                NugetPackageReference npr = new NugetPackageReference();
                npr.setId(include);
                npr.setVersion(version);
                packages.add(npr);
            }
            return packages;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | MSBuildProjectParseException | SAXException e) {
            throw new MSBuildProjectParseException("Unable to parse MSBuild project file", e);
        }
    }
}

