/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"accessVector", "accessComplexity", "authentication", "confidentialityImpact", "integrityImpact", "availabilityImpact", "baseScore"})
public class CvssV20 {
    @JsonProperty(value="accessVector")
    private AccessVectorType accessVector;
    @JsonProperty(value="accessComplexity")
    private AccessComplexityType accessComplexity;
    @JsonProperty(value="authentication")
    private AuthenticationType authentication;
    @JsonProperty(value="confidentialityImpact")
    private CiaType confidentialityImpact;
    @JsonProperty(value="integrityImpact")
    private CiaType integrityImpact;
    @JsonProperty(value="availabilityImpact")
    private CiaType availabilityImpact;
    @JsonProperty(value="baseScore")
    private Double baseScore;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="accessVector")
    public AccessVectorType getAccessVector() {
        return this.accessVector;
    }

    @JsonProperty(value="accessVector")
    public void setAccessVector(AccessVectorType accessVector) {
        this.accessVector = accessVector;
    }

    @JsonProperty(value="accessComplexity")
    public AccessComplexityType getAccessComplexity() {
        return this.accessComplexity;
    }

    @JsonProperty(value="accessComplexity")
    public void setAccessComplexity(AccessComplexityType accessComplexity) {
        this.accessComplexity = accessComplexity;
    }

    @JsonProperty(value="authentication")
    public AuthenticationType getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    public void setAuthentication(AuthenticationType authentication) {
        this.authentication = authentication;
    }

    @JsonProperty(value="confidentialityImpact")
    public CiaType getConfidentialityImpact() {
        return this.confidentialityImpact;
    }

    @JsonProperty(value="confidentialityImpact")
    public void setConfidentialityImpact(CiaType confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    @JsonProperty(value="integrityImpact")
    public CiaType getIntegrityImpact() {
        return this.integrityImpact;
    }

    @JsonProperty(value="integrityImpact")
    public void setIntegrityImpact(CiaType integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    @JsonProperty(value="availabilityImpact")
    public CiaType getAvailabilityImpact() {
        return this.availabilityImpact;
    }

    @JsonProperty(value="availabilityImpact")
    public void setAvailabilityImpact(CiaType availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    @JsonProperty(value="baseScore")
    public Double getBaseScore() {
        return this.baseScore;
    }

    @JsonProperty(value="baseScore")
    public void setBaseScore(Double baseScore) {
        this.baseScore = baseScore;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CvssV20.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("accessVector");
        sb.append('=');
        sb.append(this.accessVector == null ? "<null>" : this.accessVector);
        sb.append(',');
        sb.append("accessComplexity");
        sb.append('=');
        sb.append(this.accessComplexity == null ? "<null>" : this.accessComplexity);
        sb.append(',');
        sb.append("authentication");
        sb.append('=');
        sb.append(this.authentication == null ? "<null>" : this.authentication);
        sb.append(',');
        sb.append("confidentialityImpact");
        sb.append('=');
        sb.append(this.confidentialityImpact == null ? "<null>" : this.confidentialityImpact);
        sb.append(',');
        sb.append("integrityImpact");
        sb.append('=');
        sb.append(this.integrityImpact == null ? "<null>" : this.integrityImpact);
        sb.append(',');
        sb.append("availabilityImpact");
        sb.append('=');
        sb.append(this.availabilityImpact == null ? "<null>" : this.availabilityImpact);
        sb.append(',');
        sb.append("baseScore");
        sb.append('=');
        sb.append(this.baseScore == null ? "<null>" : this.baseScore);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.accessComplexity == null ? 0 : this.accessComplexity.hashCode());
        result = result * 31 + (this.confidentialityImpact == null ? 0 : this.confidentialityImpact.hashCode());
        result = result * 31 + (this.availabilityImpact == null ? 0 : this.availabilityImpact.hashCode());
        result = result * 31 + (this.integrityImpact == null ? 0 : this.integrityImpact.hashCode());
        result = result * 31 + (this.baseScore == null ? 0 : this.baseScore.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.accessVector == null ? 0 : this.accessVector.hashCode());
        result = result * 31 + (this.authentication == null ? 0 : this.authentication.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CvssV20)) {
            return false;
        }
        CvssV20 rhs = (CvssV20)other;
        return (this.accessComplexity == rhs.accessComplexity || this.accessComplexity != null && this.accessComplexity.equals((Object)rhs.accessComplexity)) && (this.confidentialityImpact == rhs.confidentialityImpact || this.confidentialityImpact != null && this.confidentialityImpact.equals((Object)rhs.confidentialityImpact)) && (this.availabilityImpact == rhs.availabilityImpact || this.availabilityImpact != null && this.availabilityImpact.equals((Object)rhs.availabilityImpact)) && (this.integrityImpact == rhs.integrityImpact || this.integrityImpact != null && this.integrityImpact.equals((Object)rhs.integrityImpact)) && (this.baseScore == rhs.baseScore || this.baseScore != null && this.baseScore.equals(rhs.baseScore)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.accessVector == rhs.accessVector || this.accessVector != null && this.accessVector.equals((Object)rhs.accessVector)) && (this.authentication == rhs.authentication || this.authentication != null && this.authentication.equals((Object)rhs.authentication));
    }

    public static enum CiaType {
        NONE("NONE"),
        PARTIAL("PARTIAL"),
        COMPLETE("COMPLETE");

        private final String value;
        private static final Map<String, CiaType> CONSTANTS;

        private CiaType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CiaType fromValue(String value) {
            CiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CiaType>();
            for (CiaType c : CiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AuthenticationType {
        MULTIPLE("MULTIPLE"),
        SINGLE("SINGLE"),
        NONE("NONE");

        private final String value;
        private static final Map<String, AuthenticationType> CONSTANTS;

        private AuthenticationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AuthenticationType fromValue(String value) {
            AuthenticationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AuthenticationType>();
            for (AuthenticationType c : AuthenticationType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AccessVectorType {
        NETWORK("NETWORK"),
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        LOCAL("LOCAL");

        private final String value;
        private static final Map<String, AccessVectorType> CONSTANTS;

        private AccessVectorType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AccessVectorType fromValue(String value) {
            AccessVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AccessVectorType>();
            for (AccessVectorType c : AccessVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AccessComplexityType {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, AccessComplexityType> CONSTANTS;

        private AccessComplexityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AccessComplexityType fromValue(String value) {
            AccessComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AccessComplexityType>();
            for (AccessComplexityType c : AccessComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

