/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractSuppressionAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;

@ThreadSafe
public class VulnerabilitySuppressionAnalyzer
extends AbstractSuppressionAnalyzer {
    private static final String ANALYZER_NAME = "Vulnerability Suppression Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_FINDING_ANALYSIS;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.vulnerabilitysuppression.enabled";
    }

    @Override
    public boolean filter(SuppressionRule rule) {
        return !rule.hasCve() && !rule.hasCvssBelow() && !rule.hasCwe() && !rule.hasVulnerabilityName();
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (dependency.getVulnerabilitiesCount() > 0) {
            super.analyzeDependency(dependency, engine);
        }
    }
}

