/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.processing;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.elixir.MixAuditJsonParser;
import org.owasp.dependencycheck.data.elixir.MixAuditResult;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.CvssV2;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.processing.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

public class MixAuditProcessor
extends Processor<InputStream> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MixAuditProcessor.class);
    private final Engine engine;
    private final Dependency mixDependency;
    private IOException ioException;
    private CpeValidationException cpeException;
    private AnalysisException analysisException;

    public MixAuditProcessor(Dependency mixDependency, Engine engine) {
        this.engine = engine;
        this.mixDependency = mixDependency;
    }

    public void run() {
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)this.getInput(), StandardCharsets.UTF_8));){
            this.processMixAuditOutput(rdr);
        }
        catch (IOException ex) {
            this.ioException = ex;
        }
        catch (AnalysisException ex) {
            this.analysisException = ex;
        }
        catch (CpeValidationException ex) {
            this.cpeException = ex;
        }
    }

    public void close() throws IOException, AnalysisException, CpeValidationException {
        if (this.ioException != null) {
            this.addSuppressedExceptions(this.ioException, new Throwable[]{this.analysisException, this.cpeException});
            throw this.ioException;
        }
        if (this.analysisException != null) {
            this.addSuppressedExceptions(this.analysisException, new Throwable[]{this.cpeException});
            throw this.analysisException;
        }
        if (this.cpeException != null) {
            throw this.cpeException;
        }
    }

    private void processMixAuditOutput(BufferedReader rdr) throws AnalysisException, CpeValidationException {
        MixAuditJsonParser parser = new MixAuditJsonParser(rdr);
        parser.process();
        for (MixAuditResult result : parser.getResults()) {
            Dependency dependency = this.createDependency(this.mixDependency, result.getDependencyPackage(), result.getDependencyVersion());
            Vulnerability vulnerability = this.engine.getDatabase().getVulnerability(result.getCve());
            if (vulnerability == null) {
                vulnerability = this.createVulnerability(result);
            }
            dependency.addVulnerability(vulnerability);
            this.engine.addDependency(dependency);
        }
    }

    private Dependency createDependency(Dependency parentDependency, String packageName, String version) {
        Dependency dep = new Dependency(parentDependency.getActualFile(), true);
        String identifier = String.format("%s:%s", packageName, version);
        dep.setEcosystem("exlixir");
        dep.setDisplayFileName(identifier);
        dep.setName(packageName);
        dep.setVersion(version);
        dep.setPackagePath(identifier);
        dep.setMd5sum(Checksum.getMD5Checksum((String)identifier));
        dep.setSha1sum(Checksum.getSHA1Checksum((String)identifier));
        dep.setSha256sum(Checksum.getSHA256Checksum((String)identifier));
        dep.addEvidence(EvidenceType.VERSION, "mix_audit", "Version", version, Confidence.HIGHEST);
        dep.addEvidence(EvidenceType.PRODUCT, "mix_audit", "Package", packageName, Confidence.HIGHEST);
        try {
            PackageURL purl = PackageURLBuilder.aPackageURL().withType("hex").withName(packageName).withVersion(version).build();
            dep.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
        }
        catch (MalformedPackageURLException ex) {
            LOGGER.debug("Unable to build package url for hex", (Throwable)ex);
            GenericIdentifier id = new GenericIdentifier("hex:" + packageName + "@" + version, Confidence.HIGHEST);
            dep.addSoftwareIdentifier(id);
        }
        return dep;
    }

    private Vulnerability createVulnerability(MixAuditResult result) throws CpeValidationException {
        String product = result.getDependencyPackage();
        String version = result.getDependencyVersion();
        Vulnerability vulnerability = new Vulnerability();
        vulnerability.setSource(Vulnerability.Source.MIXAUDIT);
        VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder();
        VulnerableSoftware vs = builder.part(Part.APPLICATION).vendor(String.format("%s_project", product)).product(product).version(version).build();
        vulnerability.addVulnerableSoftware(vs);
        vulnerability.setMatchedVulnerableSoftware(vs);
        vulnerability.setCvssV2(new CvssV2(-1.0f, "-", "-", "-", "-", "-", "-", "unknown"));
        vulnerability.setDescription(result.getDescription());
        vulnerability.setName(result.getCve());
        return vulnerability;
    }
}

